/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.AsyncMessage;
import org.drools.core.reteoo.AsyncMessagesCoordinator;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.AsyncReceive;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.TupleList;

public class AsyncReceiveNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<AsyncReceiveMemory> {
    private static final long serialVersionUID = 510L;
    private String messageId;
    private boolean tupleMemoryEnabled;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private AsyncReceive receive;
    private transient ObjectTypeConf objectTypeConf;

    public AsyncReceiveNode() {
    }

    public AsyncReceiveNode(int id, LeftTupleSource tupleSource, AsyncReceive receive, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, BuildContext context) {
        super(id, context);
        this.messageId = receive.getMessageId();
        this.receive = receive;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount() + 1);
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.betaConstraints.init(context, this.getType());
        this.initMasks(context, tupleSource);
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
        context.getKnowledgeBase().addReceiveNode(this);
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaConstraints getBetaConstraints() {
        return this.betaConstraints;
    }

    public Class<?> getResultClass() {
        return this.receive.getResultClass();
    }

    public ObjectTypeConf getObjectTypeConf(InternalWorkingMemory workingMemory) {
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(workingMemory.getEntryPoint(), this.getResultClass(), workingMemory.getKnowledgeBase());
        }
        return this.objectTypeConf;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    protected Pattern getLeftInputPattern(BuildContext context) {
        return context.getLastBuiltPatterns()[0];
    }

    @Override
    public String toString() {
        return "[AsyncReceiveNode(" + this.id + "): messageId=" + this.messageId + "]";
    }

    private int calculateHashCode() {
        return this.leftInput.hashCode() ^ this.messageId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsyncReceiveNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AsyncReceiveNode other = (AsyncReceiveNode)object;
        return this.leftInput.getId() != other.leftInput.getId() && this.messageId.equals(other.messageId);
    }

    @Override
    public AsyncReceiveMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new AsyncReceiveMemory(this, wm);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 137;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    public static class AsyncReceiveMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        private static final long serialVersionUID = 510L;
        private final Consumer<AsyncMessage> receiver;
        private final String messageId;
        private final TupleList insertOrUpdateLeftTuples = new TupleList();
        private final List<Object> messages = new ArrayList<Object>();
        private SegmentMemory memory;
        private long nodePosMaskBit;

        public AsyncReceiveMemory(AsyncReceiveNode node, InternalWorkingMemory wm) {
            this.messageId = node.messageId;
            this.receiver = asyncMessage -> wm.addPropagation(new AsyncReceiveAction(node, asyncMessage.getObject()));
            AsyncMessagesCoordinator.get().registerReceiver(node.messageId, this.receiver);
        }

        public void addMessage(Object message) {
            this.messages.add(message);
        }

        public List<Object> getMessages() {
            return this.messages;
        }

        public TupleList getInsertOrUpdateLeftTuples() {
            return this.insertOrUpdateLeftTuples;
        }

        public void addInsertOrUpdateLeftTuple(LeftTuple leftTuple) {
            this.insertOrUpdateLeftTuples.add(leftTuple);
        }

        @Override
        public short getNodeType() {
            return 137;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.memory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.memory = smem;
        }

        @Override
        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.nodePosMaskBit = segmentPos;
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            if (this.memory != null) {
                this.memory.updateDirtyNodeMask(this.nodePosMaskBit);
            }
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            if (this.memory != null) {
                this.memory.updateCleanNodeMask(this.nodePosMaskBit);
            }
        }

        @Override
        public void reset() {
            this.messages.clear();
        }

        public void dispose() {
            AsyncMessagesCoordinator.get().deregisterReceiver(this.messageId, this.receiver);
        }
    }

    public static class AsyncReceiveAction
    extends PropagationEntry.AbstractPropagationEntry {
        private final AsyncReceiveNode asyncReceiveNode;
        private final Object object;

        private AsyncReceiveAction(AsyncReceiveNode asyncReceiveNode, Object object) {
            this.asyncReceiveNode = asyncReceiveNode;
            this.object = object;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            AsyncReceiveMemory memory = wm.getNodeMemory(this.asyncReceiveNode);
            memory.addMessage(this.object);
            memory.setNodeDirtyWithoutNotify();
            for (PathMemory pmem : memory.getSegmentMemory().getPathMemories()) {
                if (pmem.getPathEndNode().getAssociatedRuleSize() == 0) continue;
                InternalAgenda agenda = pmem.getActualAgenda(wm);
                pmem.doLinkRule(agenda);
            }
        }
    }
}

