/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.From;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.TupleList;

public class FromNode<T extends FromMemory>
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<T> {
    private static final long serialVersionUID = 510L;
    protected DataProvider dataProvider;
    protected AlphaNodeFieldConstraint[] alphaConstraints;
    protected BetaConstraints betaConstraints;
    protected LeftTupleSinkNode previousTupleSinkNode;
    protected LeftTupleSinkNode nextTupleSinkNode;
    protected From from;
    protected boolean tupleMemoryEnabled;
    protected transient ObjectTypeConf objectTypeConf;

    public FromNode() {
    }

    public FromNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context, From from) {
        super(id, context);
        this.dataProvider = dataProvider;
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount() + 1);
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.betaConstraints.init(context, this.getType());
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.from = from;
        this.initMasks(context, tupleSource);
        this.hashcode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.dataProvider.hashCode();
        if (this.from.getResultPattern() != null) {
            hash += 31 * this.from.getResultPattern().hashCode();
        }
        if (this.alphaConstraints != null) {
            hash += 37 * Arrays.hashCode(this.alphaConstraints);
        }
        if (this.betaConstraints != null) {
            hash += 41 * this.betaConstraints.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FromNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        FromNode other = (FromNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.dataProvider.equals(other.dataProvider) && ClassUtils.areNullSafeEquals(this.from.getResultPattern(), other.from.getResultPattern()) && Arrays.equals(this.alphaConstraints, other.alphaConstraints) && this.betaConstraints.equals(other.betaConstraints);
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaConstraints getBetaConstraints() {
        return this.betaConstraints;
    }

    @Override
    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        Class<?> objectClass;
        super.initDeclaredMask(context, leftInput);
        if (this.leftDeclaredMask.isAllSet()) {
            return;
        }
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.leftDeclaredMask = AllSetBitMask.get();
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[1];
        if (pattern == null) {
            return;
        }
        ObjectType objectType = pattern.getObjectType();
        if (objectType instanceof ClassObjectType && PropertySpecificUtil.isPropertyReactive(context, objectClass = ((ClassWireable)((Object)objectType)).getClassType())) {
            Collection<String> leftListenedProperties = pattern.getListenedProperties();
            List<String> accessibleProperties = PropertySpecificUtil.getAccessibleProperties(context.getKnowledgeBase(), objectClass);
            this.leftDeclaredMask = this.leftDeclaredMask.setAll(PropertySpecificUtil.calculatePositiveMask(objectClass, leftListenedProperties, accessibleProperties));
            this.leftNegativeMask = this.leftNegativeMask.setAll(PropertySpecificUtil.calculateNegativeMask(objectClass, leftListenedProperties, accessibleProperties));
        }
    }

    @Override
    protected Pattern getLeftInputPattern(BuildContext context) {
        return context.getLastBuiltPatterns()[0];
    }

    @Override
    protected BitMask setNodeConstraintsPropertyReactiveMask(BitMask mask, Class objectClass, List<String> accessibleProperties) {
        for (int i = 0; i < this.alphaConstraints.length; ++i) {
            mask = mask.setAll(this.alphaConstraints[i].getListenedPropertyMask(objectClass, accessibleProperties));
        }
        return mask;
    }

    public Class<?> getResultClass() {
        return this.from.getResultClass();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public RightTuple createRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Object object) {
        return new RightTupleImpl(this.createFactHandle(workingMemory, object));
    }

    public InternalFactHandle createFactHandle(InternalWorkingMemory workingMemory, Object object) {
        InternalFactHandle handle = DefaultKnowledgeHelper.getFactHandleFromWM(workingMemory, object);
        if (handle != null && handle.getObject() == object) {
            return handle;
        }
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(workingMemory.getEntryPoint(), this.getResultClass(), workingMemory.getKnowledgeBase());
        }
        return workingMemory.getFactHandleFactory().newFactHandle(object, this.objectTypeConf, workingMemory, null);
    }

    public void addToCreatedHandlesMap(Map<Object, RightTuple> matches, RightTuple rightTuple) {
        if (rightTuple.getFactHandle().isValid()) {
            Object object = rightTuple.getFactHandle().getObject();
            RightTuple existingMatch = matches.get(object);
            if (existingMatch != null) {
                rightTuple.setNext(existingMatch);
            }
            matches.put(object, rightTuple);
        }
    }

    @Override
    public T createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        BetaMemory beta = new BetaMemory(new TupleList(), null, this.betaConstraints.createContext(), 151);
        return (T)new FromMemory(beta, this.dataProvider);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 151;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    public static class FromMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Serializable,
    SegmentNodeMemory {
        private static final long serialVersionUID = 510L;
        private DataProvider dataProvider;
        private final BetaMemory betaMemory;
        public Object providerContext;

        public FromMemory(BetaMemory betaMemory, DataProvider dataProvider) {
            this.betaMemory = betaMemory;
            this.dataProvider = dataProvider;
            this.providerContext = dataProvider.createContext();
        }

        @Override
        public short getNodeType() {
            return 151;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public void reset() {
            this.betaMemory.reset();
            this.providerContext = this.dataProvider.createContext();
        }

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

