/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.infinispan.quarkus.hibernate.cache.CaffeineCache;
import org.infinispan.quarkus.hibernate.cache.DomainDataRegionImpl;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalCacheConfig;
import org.infinispan.quarkus.hibernate.cache.QueryResultsRegionImpl;
import org.infinispan.quarkus.hibernate.cache.Sync;
import org.infinispan.quarkus.hibernate.cache.Time;
import org.infinispan.quarkus.hibernate.cache.TimestampsRegionImpl;
import org.jboss.logging.Logger;

public final class QuarkusInfinispanRegionFactory
implements RegionFactory {
    private static final Logger log = Logger.getLogger(QuarkusInfinispanRegionFactory.class);
    private static final String PREFIX = "hibernate.cache.";
    private static final String OBJECT_COUNT_SUFFIX = ".memory.object-count";
    private static final String MAX_IDLE_SUFFIX = ".expiration.max-idle";
    private final Map<String, InternalCache> caches = new HashMap<String, InternalCache>();
    private SessionFactoryOptions settings;
    private CacheKeysFactory cacheKeysFactory;
    private List<Region> regions = new ArrayList<Region>();
    private Map<String, InternalCacheConfig> cacheConfigs;
    private Time.MillisService regionTimeService;
    private Time.NanosService cacheTimeService;

    public QuarkusInfinispanRegionFactory() {
    }

    public QuarkusInfinispanRegionFactory(Properties props) {
        this();
    }

    public void start(SessionFactoryOptions settings, Map configValues) {
        log.debug((Object)"Starting Infinispan region factory");
        this.cacheKeysFactory = this.determineCacheKeysFactory(settings, configValues);
        if (this.regionTimeService == null) {
            this.regionTimeService = Time.MillisService.SYSTEM;
        }
        if (this.cacheTimeService == null) {
            this.cacheTimeService = CaffeineCache.TIME_SERVICE;
        }
        this.settings = settings;
        this.cacheConfigs = this.computeCacheConfigs(configValues);
    }

    private String extractRegionName(int prefixIndexEnd, String key) {
        int suffixIndex = Math.max(key.indexOf(OBJECT_COUNT_SUFFIX), key.indexOf(MAX_IDLE_SUFFIX));
        if (suffixIndex != -1) {
            return key.substring(prefixIndexEnd, suffixIndex);
        }
        return null;
    }

    private String extractProperty(String key, Map properties) {
        String value = ConfigurationHelper.extractPropertyValue((String)key, (Map)properties);
        log.debugf("Configuration override via property %s: %s", (Object)key, (Object)value);
        return value;
    }

    private CacheKeysFactory determineCacheKeysFactory(SessionFactoryOptions settings, Map properties) {
        return (CacheKeysFactory)((StrategySelector)settings.getServiceRegistry().getService(StrategySelector.class)).resolveDefaultableStrategy(CacheKeysFactory.class, properties.get("hibernate.cache.keys_factory"), (Object)DefaultCacheKeysFactory.INSTANCE);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public String qualify(String regionName) {
        return RegionNameQualifier.INSTANCE.qualify(regionName, this.settings);
    }

    public CacheTransactionSynchronization createTransactionContext(SharedSessionContractImplementor session) {
        return new Sync(this);
    }

    public long nextTimestamp() {
        return this.regionTimeService.milliTime();
    }

    void setRegionTimeService(Time.MillisService regionTimeService) {
        this.regionTimeService = regionTimeService;
    }

    void setCacheTimeService(Time.NanosService cacheTimeService) {
        this.cacheTimeService = cacheTimeService;
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext ctx) {
        log.debugf("Building domain data region [%s] entities=%s collections=%s naturalIds=%s", new Object[]{regionConfig.getRegionName(), regionConfig.getEntityCaching(), regionConfig.getCollectionCaching(), regionConfig.getNaturalIdCaching()});
        String cacheName = this.qualify(regionConfig.getRegionName());
        InternalCache cache = this.getCache(cacheName);
        DomainDataRegionImpl region = new DomainDataRegionImpl(cache, regionConfig, this.cacheKeysFactory, this);
        this.regions.add((Region)region);
        return region;
    }

    private InternalCache getCache(String cacheName) {
        return this.caches.compute(cacheName, (ignore, cache) -> {
            if (cache == null) {
                InternalCacheConfig userDefinedCacheConfig = this.cacheConfigs.get(cacheName);
                InternalCacheConfig cacheConfig = userDefinedCacheConfig == null ? QuarkusInfinispanRegionFactory.defaultDomainCacheConfig() : userDefinedCacheConfig;
                cache = new CaffeineCache(cacheName, cacheConfig, this.cacheTimeService);
            }
            return cache;
        });
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessionFactoryImplementor) {
        log.debugf("Building query results cache region [%s]", (Object)regionName);
        String cacheName = this.qualify(regionName);
        InternalCache cache = this.getCache(cacheName);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cache, regionName, this);
        this.regions.add((Region)region);
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        log.debugf("Building timestamps cache region [%s]", (Object)regionName);
        String cacheName = this.qualify(regionName);
        InternalCache cache = this.getCache(cacheName);
        TimestampsRegionImpl region = new TimestampsRegionImpl(cache, regionName, this);
        this.regions.add((Region)region);
        return region;
    }

    public void stop() {
        log.debug((Object)"Stop region factory");
        this.stopCacheRegions();
        this.stopCaches();
    }

    private void stopCaches() {
        this.caches.forEach((name, cache) -> cache.stop());
    }

    private void stopCacheRegions() {
        log.debug((Object)"Clear region references");
        this.regions.forEach(Region::destroy);
        this.regions.clear();
    }

    private HashMap<String, InternalCacheConfig> computeCacheConfigs(Map configValues) {
        HashMap<String, InternalCacheConfig> cacheConfigs = new HashMap<String, InternalCacheConfig>();
        cacheConfigs.put("default-query-results-region", QuarkusInfinispanRegionFactory.defaultQueryCacheConfig());
        cacheConfigs.put("default-update-timestamps-region", QuarkusInfinispanRegionFactory.defaultTimestampsCacheConfig());
        for (Object k : configValues.keySet()) {
            int prefixIndexEnd;
            String regionName;
            String key = (String)k;
            int prefixIndex = key.indexOf(PREFIX);
            if (prefixIndex == -1 || (regionName = this.extractRegionName(prefixIndexEnd = prefixIndex + PREFIX.length(), key)) == null) continue;
            cacheConfigs.compute(regionName, (ignore, cacheConfig) -> {
                String value = this.extractProperty(key, configValues);
                if (cacheConfig == null) {
                    cacheConfig = QuarkusInfinispanRegionFactory.defaultDomainCacheConfig();
                }
                if (key.contains(OBJECT_COUNT_SUFFIX)) {
                    cacheConfig.objectCount = Long.parseLong(value);
                } else if (key.contains(MAX_IDLE_SUFFIX)) {
                    cacheConfig.maxIdle = Duration.ofSeconds(Long.parseLong(value));
                }
                return cacheConfig;
            });
        }
        return cacheConfigs;
    }

    private static InternalCacheConfig defaultQueryCacheConfig() {
        InternalCacheConfig cacheConfig = new InternalCacheConfig();
        cacheConfig.maxIdle = Duration.ofSeconds(100L);
        cacheConfig.objectCount = 10000L;
        return cacheConfig;
    }

    private static InternalCacheConfig defaultTimestampsCacheConfig() {
        InternalCacheConfig cacheConfig = new InternalCacheConfig();
        cacheConfig.maxIdle = Time.forever();
        cacheConfig.objectCount = -1L;
        return cacheConfig;
    }

    private static InternalCacheConfig defaultDomainCacheConfig() {
        InternalCacheConfig cacheConfig = new InternalCacheConfig();
        cacheConfig.maxIdle = Duration.ofSeconds(100L);
        cacheConfig.objectCount = 10000L;
        return cacheConfig;
    }

    public Optional<Long> getMemoryObjectCount(String region) {
        InternalCacheConfig config = this.cacheConfigs.get(region);
        return config == null ? Optional.empty() : Optional.of(config.objectCount);
    }

    public Optional<Duration> getExpirationMaxIdle(String region) {
        InternalCacheConfig config = this.cacheConfigs.get(region);
        return config == null ? Optional.empty() : Optional.of(config.maxIdle);
    }
}

