/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.schema;

import io.quarkus.datasource.runtime.DatabaseSchemaProvider;
import io.quarkus.runtime.LaunchMode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaManagementIntegrator
implements Integrator,
DatabaseSchemaProvider {
    private static final Logger log = Logger.getLogger(SchemaManagementIntegrator.class);
    private static final Map<String, Holder> metadataMap = new ConcurrentHashMap<String, Holder>();
    private static final Map<String, String> datasourceToPuMap = new ConcurrentHashMap<String, String>();
    private static final Map<SessionFactoryImplementor, String> nameCache = Collections.synchronizedMap(new IdentityHashMap());

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        String name = SchemaManagementIntegrator.defaultName(sessionFactory);
        metadataMap.put(name, new Holder(metadata, sessionFactory, serviceRegistry));
        nameCache.put(sessionFactory, name);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        String name = nameCache.remove(sessionFactory);
        if (name != null) {
            metadataMap.remove(name);
        }
    }

    public static void clearDsMap() {
        datasourceToPuMap.clear();
    }

    public static void mapDatasource(String datasource, String pu) {
        datasourceToPuMap.put(datasource, pu);
    }

    static String defaultName(SessionFactoryImplementor sf) {
        String name = sf.getName();
        if (name != null) {
            return name;
        }
        if (nameCache.containsKey(name)) {
            return nameCache.get(name);
        }
        Object prop = sf.getProperties().get("hibernate.ejb.persistenceUnitName");
        if (prop != null) {
            return prop.toString();
        }
        return "<default>";
    }

    public static void recreateDatabases() {
        if (!LaunchMode.current().isDevOrTest()) {
            throw new IllegalStateException("Can only be used in dev or test mode");
        }
        for (String val : metadataMap.keySet()) {
            SchemaManagementIntegrator.recreateDatabase(val);
        }
    }

    public static void recreateDatabase(String name) {
        if (!LaunchMode.current().isDevOrTest()) {
            throw new IllegalStateException("Can only be used in dev or test mode");
        }
        Holder val = metadataMap.get(name);
        Object prop = val.sessionFactory.getProperties().get("javax.persistence.schema-generation.database.action");
        if (prop != null && !prop.toString().equals("none")) {
            SchemaManagementTool schemaManagementTool = (SchemaManagementTool)val.sessionFactory.getServiceRegistry().getService(SchemaManagementTool.class);
            SchemaDropper schemaDropper = schemaManagementTool.getSchemaDropper(new HashMap());
            schemaDropper.doDrop(val.metadata, (ExecutionOptions)new SimpleExecutionOptions(), (SourceDescriptor)new SimpleSourceDescriptor(), (TargetDescriptor)new SimpleTargetDescriptor());
            schemaManagementTool.getSchemaCreator(new HashMap()).doCreation(val.metadata, (ExecutionOptions)new SimpleExecutionOptions(), (SourceDescriptor)new SimpleSourceDescriptor(), (TargetDescriptor)new SimpleTargetDescriptor());
        }
        val.sessionFactory.getCache().evictAll();
        val.sessionFactory.getCache().evictQueries();
    }

    public void resetDatabase(String dbName) {
        String name = datasourceToPuMap.get(dbName);
        if (name == null) {
            return;
        }
        SchemaManagementIntegrator.recreateDatabase(name);
    }

    public void resetAllDatabases() {
        SchemaManagementIntegrator.recreateDatabases();
    }

    private static class SimpleTargetDescriptor
    implements TargetDescriptor {
        private SimpleTargetDescriptor() {
        }

        public EnumSet<TargetType> getTargetTypes() {
            return EnumSet.of(TargetType.DATABASE);
        }

        public ScriptTargetOutput getScriptTargetOutput() {
            return null;
        }
    }

    private static class SimpleSourceDescriptor
    implements SourceDescriptor {
        private SimpleSourceDescriptor() {
        }

        public SourceType getSourceType() {
            return SourceType.METADATA;
        }

        public ScriptSourceInput getScriptSourceInput() {
            return null;
        }
    }

    private static class SimpleExecutionOptions
    implements ExecutionOptions {
        private SimpleExecutionOptions() {
        }

        public Map getConfigurationValues() {
            return Collections.emptyMap();
        }

        public boolean shouldManageNamespaces() {
            return false;
        }

        public ExceptionHandler getExceptionHandler() {
            return new ExceptionHandler(){

                public void handleException(CommandAcceptanceException exception) {
                    log.error((Object)"Failed to recreate schema", (Throwable)exception);
                }
            };
        }
    }

    static class Holder {
        final Metadata metadata;
        final SessionFactoryImplementor sessionFactory;
        final SessionFactoryServiceRegistry serviceRegistry;

        Holder(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
            this.metadata = metadata;
            this.sessionFactory = sessionFactory;
            this.serviceRegistry = serviceRegistry;
        }
    }
}

