/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.Components;
import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.RemovedBean;
import io.quarkus.arc.ResourceReferenceProvider;
import io.quarkus.arc.impl.ApplicationContext;
import io.quarkus.arc.impl.ArcCDIProvider;
import io.quarkus.arc.impl.BeanManagerBean;
import io.quarkus.arc.impl.BeanManagerImpl;
import io.quarkus.arc.impl.BeanTypeAssignabilityRules;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.EventBean;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.EventTypeAssignabilityRules;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.InstanceBean;
import io.quarkus.arc.impl.InstanceHandleImpl;
import io.quarkus.arc.impl.InstanceImpl;
import io.quarkus.arc.impl.InterceptedStaticMethods;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.impl.Qualifiers;
import io.quarkus.arc.impl.Reflections;
import io.quarkus.arc.impl.RequestContext;
import io.quarkus.arc.impl.SingletonContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Event;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

public class ArcContainerImpl
implements ArcContainer {
    private static final Logger LOGGER = Logger.getLogger((String)ArcContainerImpl.class.getPackage().getName());
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private final String id = String.valueOf(ID_GENERATOR.incrementAndGet());
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final ArrayList<InjectableBean<?>> beans = new ArrayList();
    private final ArrayList<RemovedBean> removedBeans = new ArrayList();
    private final List<InjectableInterceptor<?>> interceptors = new ArrayList();
    private final List<InjectableDecorator<?>> decorators = new ArrayList();
    private final List<InjectableObserverMethod<?>> observers = new ArrayList();
    private final Map<Class<? extends Annotation>, Set<Annotation>> transitiveInterceptorBindings = new HashMap<Class<? extends Annotation>, Set<Annotation>>();
    private final Map<String, Set<String>> qualifierNonbindingMembers = new HashMap<String, Set<String>>();
    private final Map<Class<? extends Annotation>, Collection<InjectableContext>> contexts;
    private final ManagedContext requestContext;
    private final InjectableContext applicationContext = new ApplicationContext();
    private final InjectableContext singletonContext = new SingletonContext();
    private final ComputingCache<Resolvable, Set<InjectableBean<?>>> resolved;
    private final ComputingCache<String, InjectableBean<?>> beansById;
    private final ComputingCache<String, Set<InjectableBean<?>>> beansByName;
    private final ArrayList<ResourceReferenceProvider> resourceProviders;
    final InstanceImpl<Object> instance;
    private volatile ExecutorService executorService;

    public ArcContainerImpl() {
        this.requestContext = new RequestContext();
        this.contexts = new HashMap<Class<? extends Annotation>, Collection<InjectableContext>>();
        this.putContext(this.requestContext);
        this.putContext(this.applicationContext);
        this.putContext(this.singletonContext);
        for (ComponentsProvider componentsProvider : ServiceLoader.load(ComponentsProvider.class)) {
            Components components = componentsProvider.getComponents();
            for (InjectableBean<?> bean : components.getBeans()) {
                if (bean instanceof InjectableInterceptor) {
                    this.interceptors.add((InjectableInterceptor)bean);
                    continue;
                }
                if (bean instanceof InjectableDecorator) {
                    this.decorators.add((InjectableDecorator)bean);
                    continue;
                }
                this.beans.add(bean);
            }
            this.removedBeans.addAll(components.getRemovedBeans());
            this.removedBeans.trimToSize();
            this.observers.addAll(components.getObservers());
            for (InjectableContext context : components.getContexts()) {
                if (ApplicationScoped.class.equals((Object)context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in application context is always active: " + context);
                }
                if (Singleton.class.equals((Object)context.getScope())) {
                    throw new IllegalStateException("Failed to register a context - built-in singleton context is always active: " + context);
                }
                this.putContext(context);
            }
            this.transitiveInterceptorBindings.putAll(components.getTransitiveInterceptorBindings());
            this.qualifierNonbindingMembers.putAll(components.getQualifierNonbindingMembers());
        }
        ArcContainerImpl.addBuiltInBeans(this.beans);
        this.beans.trimToSize();
        this.interceptors.sort((i1, i2) -> Integer.compare(i2.getPriority(), i1.getPriority()));
        this.resolved = new ComputingCache<Resolvable, Set>(this::resolve);
        this.beansById = new ComputingCache<String, InjectableBean>(this::findById);
        this.beansByName = new ComputingCache<String, Set>(this::resolve);
        this.resourceProviders = new ArrayList();
        for (ResourceReferenceProvider resourceProvider : ServiceLoader.load(ResourceReferenceProvider.class)) {
            this.resourceProviders.add(resourceProvider);
        }
        this.resourceProviders.trimToSize();
        this.instance = InstanceImpl.of(Object.class, Collections.emptySet());
    }

    private void putContext(InjectableContext context) {
        Collection<InjectableContext> values = this.contexts.get(context.getScope());
        if (values == null) {
            this.contexts.put(context.getScope(), Collections.singleton(context));
        } else {
            ArrayList<InjectableContext> multi = new ArrayList<InjectableContext>(values.size() + 1);
            multi.addAll(values);
            multi.add(context);
            this.contexts.put(context.getScope(), Collections.unmodifiableList(multi));
        }
    }

    private static void addBuiltInBeans(List<InjectableBean<?>> beans) {
        beans.add(new BeanManagerBean());
        beans.add(new EventBean());
        beans.add(InstanceBean.INSTANCE);
    }

    public void init() {
        this.requireRunning();
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(4);
        qualifiers.add((Annotation)Initialized.Literal.APPLICATION);
        qualifiers.add((Annotation)Any.Literal.INSTANCE);
        EventImpl.createNotifier(Object.class, Object.class, qualifiers, this, false).notify(this.toString());
        CDI.setCDIProvider((CDIProvider)new ArcCDIProvider());
        LOGGER.debugf("ArC DI container initialized [beans=%s, observers=%s]", this.beans.size(), this.observers.size());
    }

    @Override
    public InjectableContext getActiveContext(Class<? extends Annotation> scopeType) {
        this.requireRunning();
        if (ApplicationScoped.class.equals(scopeType)) {
            return this.applicationContext;
        }
        if (Singleton.class.equals(scopeType)) {
            return this.singletonContext;
        }
        Collection<InjectableContext> contextsForScope = this.contexts.get(scopeType);
        InjectableContext selected = null;
        if (contextsForScope != null) {
            for (InjectableContext context : contextsForScope) {
                if (!context.isActive()) continue;
                if (selected != null) {
                    throw new IllegalArgumentException("More than one context object for the given scope: " + selected + " " + context);
                }
                selected = context;
            }
        }
        return selected;
    }

    @Override
    public Collection<InjectableContext> getContexts(Class<? extends Annotation> scopeType) {
        this.requireRunning();
        return this.contexts.getOrDefault(scopeType, Collections.emptyList());
    }

    @Override
    public Set<Class<? extends Annotation>> getScopes() {
        return new HashSet<Class<? extends Annotation>>(this.contexts.keySet());
    }

    @Override
    public <T> InstanceHandle<T> instance(Class<T> type, Annotation ... qualifiers) {
        this.requireRunning();
        return this.instanceHandle(type, qualifiers);
    }

    @Override
    public <T> InstanceHandle<T> instance(TypeLiteral<T> type, Annotation ... qualifiers) {
        this.requireRunning();
        return this.instanceHandle(type.getType(), qualifiers);
    }

    @Override
    public <X> InstanceHandle<X> instance(Type type, Annotation ... qualifiers) {
        this.requireRunning();
        return this.instanceHandle(type, qualifiers);
    }

    @Override
    public <T> Supplier<InstanceHandle<T>> instanceSupplier(Class<T> type, Annotation ... qualifiers) {
        InjectableBean<?> bean;
        Set<InjectableBean<?>> resolvedBeans;
        this.requireRunning();
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        Set<InjectableBean<?>> filteredBean = resolvedBeans = this.resolved.getValue(new Resolvable(type, qualifiers));
        if (resolvedBeans.size() > 1) {
            filteredBean = new HashSet();
            for (InjectableBean<?> i : resolvedBeans) {
                if (!i.getBeanClass().equals(type)) continue;
                filteredBean.add(i);
            }
        }
        InjectableBean<?> injectableBean = bean = filteredBean.size() != 1 ? null : filteredBean.iterator().next();
        if (bean == null) {
            return null;
        }
        return new Supplier<InstanceHandle<T>>(){

            @Override
            public InstanceHandle<T> get() {
                return ArcContainerImpl.this.beanInstanceHandle(bean, null);
            }
        };
    }

    @Override
    public <T> InstanceHandle<T> instance(InjectableBean<T> bean) {
        Objects.requireNonNull(bean);
        this.requireRunning();
        return this.beanInstanceHandle(bean, null);
    }

    @Override
    public <T> InjectableInstance<T> select(Class<T> type, Annotation ... qualifiers) {
        return this.instance.select(type, qualifiers);
    }

    @Override
    public <T> InjectableInstance<T> select(TypeLiteral<T> type, Annotation ... qualifiers) {
        return this.instance.select((TypeLiteral)type, qualifiers);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public <T> InjectableBean<T> bean(String beanIdentifier) {
        Objects.requireNonNull(beanIdentifier);
        this.requireRunning();
        return this.beansById.getValue(beanIdentifier);
    }

    @Override
    public <T> InstanceHandle<T> instance(String name) {
        Objects.requireNonNull(name);
        this.requireRunning();
        Set<InjectableBean<?>> resolvedBeans = this.beansByName.getValue(name);
        return resolvedBeans.size() != 1 ? InstanceHandleImpl.unavailable() : this.beanInstanceHandle(resolvedBeans.iterator().next(), null);
    }

    @Override
    public ManagedContext requestContext() {
        this.requireRunning();
        return this.requestContext;
    }

    @Override
    public BeanManager beanManager() {
        return BeanManagerImpl.INSTANCE.get();
    }

    @Override
    public ExecutorService getExecutorService() {
        ExecutorService executor = this.executorService;
        return executor != null ? executor : ForkJoinPool.commonPool();
    }

    public void setExecutor(ExecutorService executor) {
        this.executorService = executor;
    }

    public String toString() {
        return "ArcContainerImpl [id=" + this.id + ", running=" + this.running + ", beans=" + this.beans.size() + ", observers=" + this.observers.size() + ", scopes=" + this.getScopes() + "]";
    }

    public synchronized void shutdown() {
        if (this.running.get()) {
            CDI cdi = CDI.current();
            if (cdi instanceof ArcCDIProvider.ArcCDI) {
                ArcCDIProvider.ArcCDI arcCdi = (ArcCDIProvider.ArcCDI)cdi;
                arcCdi.destroy();
            }
            this.requestContext.terminate();
            HashSet<Annotation> beforeDestroyQualifiers = new HashSet<Annotation>(4);
            beforeDestroyQualifiers.add((Annotation)BeforeDestroyed.Literal.APPLICATION);
            beforeDestroyQualifiers.add((Annotation)Any.Literal.INSTANCE);
            try {
                EventImpl.createNotifier(Object.class, Object.class, beforeDestroyQualifiers, this, false).notify(this.toString());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"An error occurred during delivery of the @BeforeDestroyed(ApplicationScoped.class) event", (Throwable)e);
            }
            this.applicationContext.destroy();
            HashSet<Annotation> destroyQualifiers = new HashSet<Annotation>(4);
            destroyQualifiers.add((Annotation)Destroyed.Literal.APPLICATION);
            destroyQualifiers.add((Annotation)Any.Literal.INSTANCE);
            try {
                EventImpl.createNotifier(Object.class, Object.class, destroyQualifiers, this, false).notify(this.toString());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"An error occurred during delivery of the @Destroyed(ApplicationScoped.class) event", (Throwable)e);
            }
            this.singletonContext.destroy();
            Reflections.clearCaches();
            this.contexts.clear();
            this.beans.clear();
            this.removedBeans.clear();
            this.resolved.clear();
            this.observers.clear();
            this.running.set(false);
            InterceptedStaticMethods.clear();
            LOGGER.debugf("ArC DI container shut down", new Object[0]);
        }
    }

    public List<InjectableBean<?>> getBeans() {
        return new ArrayList(this.beans);
    }

    public List<RemovedBean> getRemovedBeans() {
        return Collections.unmodifiableList(this.removedBeans);
    }

    public List<InjectableInterceptor<?>> getInterceptors() {
        return new ArrayList(this.interceptors);
    }

    public List<InjectableObserverMethod<?>> getObservers() {
        return new ArrayList(this.observers);
    }

    InstanceHandle<Object> getResource(Type type, Set<Annotation> annotations) {
        for (ResourceReferenceProvider resourceProvider : this.resourceProviders) {
            InstanceHandle<Object> ret = resourceProvider.get(type, annotations);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private <T> InstanceHandle<T> instanceHandle(Type type, Annotation ... qualifiers) {
        return this.beanInstanceHandle(this.getBean(type, qualifiers), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext, boolean resetCurrentInjectionPoint, Consumer<T> destroyLogic) {
        if (bean != null) {
            if (parentContext == null && Dependent.class.equals(bean.getScope())) {
                parentContext = new CreationalContextImpl(null);
            }
            CreationalContextImpl<T> creationalContext = parentContext != null ? parentContext.child(bean) : new CreationalContextImpl<T>(bean);
            InjectionPoint prev = null;
            if (resetCurrentInjectionPoint) {
                prev = InjectionPointProvider.set(CurrentInjectionPointProvider.EMPTY);
            }
            try {
                InstanceHandleImpl<Object> instanceHandleImpl = new InstanceHandleImpl<Object>(bean, bean.get(creationalContext), creationalContext, parentContext, destroyLogic);
                return instanceHandleImpl;
            }
            finally {
                if (resetCurrentInjectionPoint) {
                    InjectionPointProvider.set(prev);
                }
            }
        }
        return InstanceHandleImpl.unavailable();
    }

    <T> InstanceHandle<T> beanInstanceHandle(InjectableBean<T> bean, CreationalContextImpl<T> parentContext) {
        return ArcContainerImpl.beanInstanceHandle(bean, parentContext, true, null);
    }

    private <T> InjectableBean<T> getBean(Type requiredType, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        } else {
            Qualifiers.verify(qualifiers);
        }
        Set<InjectableBean<?>> resolvedBeans = this.resolved.getValue(new Resolvable(requiredType, qualifiers));
        return resolvedBeans.size() != 1 ? null : resolvedBeans.iterator().next();
    }

    Set<Bean<?>> getBeans(Type requiredType, Annotation ... qualifiers) {
        if (requiredType instanceof TypeVariable) {
            throw new IllegalArgumentException("The given type is a type variable: " + requiredType);
        }
        Qualifiers.verify(qualifiers);
        return Set.of(this.getMatchingBeans(new Resolvable(requiredType, qualifiers)).toArray(new Bean[0]));
    }

    Set<Bean<?>> getBeans(String name) {
        return new HashSet(this.getMatchingBeans(name));
    }

    Map<Class<? extends Annotation>, Set<Annotation>> getTransitiveInterceptorBindings() {
        return this.transitiveInterceptorBindings;
    }

    boolean isScope(Class<? extends Annotation> annotationType) {
        if (annotationType.isAnnotationPresent(Scope.class) || annotationType.isAnnotationPresent(NormalScope.class)) {
            return true;
        }
        for (Class<? extends Annotation> scopeType : this.contexts.keySet()) {
            if (!scopeType.equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    boolean isNormalScope(Class<? extends Annotation> annotationType) {
        if (annotationType.isAnnotationPresent(NormalScope.class)) {
            return true;
        }
        Collection<InjectableContext> injectableContexts = this.contexts.get(annotationType);
        if (injectableContexts != null) {
            for (InjectableContext context : injectableContexts) {
                if (!context.isNormal()) continue;
                return true;
            }
        }
        return false;
    }

    private Set<InjectableBean<?>> resolve(Resolvable resolvable) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(resolvable));
    }

    private Set<InjectableBean<?>> resolve(String name) {
        return ArcContainerImpl.resolve(this.getMatchingBeans(name));
    }

    private InjectableBean<?> findById(String identifier) {
        for (InjectableBean<?> injectableBean : this.beans) {
            if (!injectableBean.getIdentifier().equals(identifier)) continue;
            return injectableBean;
        }
        for (InjectableInterceptor injectableInterceptor : this.interceptors) {
            if (!injectableInterceptor.getIdentifier().equals(identifier)) continue;
            return injectableInterceptor;
        }
        return null;
    }

    static <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() == 1) {
            return beans.iterator().next();
        }
        if (beans.stream().allMatch(InjectableBean.class::isInstance)) {
            ArrayList matching = new ArrayList(beans.size());
            for (Bean<X> bean : beans) {
                matching.add((InjectableBean)bean);
            }
            Set<InjectableBean<?>> resolved = ArcContainerImpl.resolve(matching);
            if (resolved.size() != 1) {
                throw new AmbiguousResolutionException(resolved.toString());
            }
            return resolved.iterator().next();
        }
        HashSet<Bean<X>> resolved = new HashSet<Bean<X>>(beans);
        resolved.removeIf(Predicate.not(BeanAttributes::isAlternative));
        if (resolved.size() != 1) {
            throw new AmbiguousResolutionException(((Object)resolved).toString());
        }
        return (Bean)resolved.iterator().next();
    }

    private static Set<InjectableBean<?>> resolve(List<InjectableBean<?>> matching) {
        if (matching.isEmpty()) {
            return Collections.emptySet();
        }
        if (matching.size() == 1) {
            return Set.of(matching.get(0));
        }
        ArrayList nonDefault = new ArrayList(matching);
        nonDefault.removeIf(InjectableBean::isDefaultBean);
        if (nonDefault.isEmpty()) {
            return Set.copyOf(matching);
        }
        if (nonDefault.size() == 1) {
            return Set.of((InjectableBean)nonDefault.get(0));
        }
        ArrayList priorityBeans = new ArrayList(nonDefault);
        priorityBeans.removeIf(Predicate.not(ArcContainerImpl::isAlternativeOrDeclaredOnAlternative));
        if (priorityBeans.isEmpty()) {
            return Set.copyOf(nonDefault);
        }
        if (priorityBeans.size() == 1) {
            return Set.of((InjectableBean)priorityBeans.get(0));
        }
        priorityBeans.sort(ArcContainerImpl::compareAlternativeBeans);
        Integer highest = ArcContainerImpl.getAlternativePriority((InjectableBean)priorityBeans.get(0));
        priorityBeans.removeIf(bean -> !highest.equals(ArcContainerImpl.getAlternativePriority(bean)));
        if (priorityBeans.size() == 1) {
            return Set.of((InjectableBean)priorityBeans.get(0));
        }
        return Set.copyOf(priorityBeans);
    }

    private static boolean isAlternativeOrDeclaredOnAlternative(InjectableBean<?> bean) {
        return bean.getAlternativePriority() != null || bean.getDeclaringBean() != null && bean.getDeclaringBean().getAlternativePriority() != null;
    }

    private static Integer getAlternativePriority(InjectableBean<?> bean) {
        Integer beanPriority = bean.getAlternativePriority();
        if (beanPriority == null && bean.getDeclaringBean() != null) {
            beanPriority = bean.getDeclaringBean().getAlternativePriority();
        }
        return beanPriority;
    }

    List<InjectableBean<?>> getMatchingBeans(Resolvable resolvable) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.beans) {
            if (!this.matches(bean, resolvable.requiredType, resolvable.qualifiers)) continue;
            matching.add(bean);
        }
        if (matching.isEmpty() && !this.removedBeans.isEmpty()) {
            ArrayList<RemovedBean> removedMatching = new ArrayList<RemovedBean>();
            for (RemovedBean removedBean : this.removedBeans) {
                if (!this.matches(removedBean.getTypes(), removedBean.getQualifiers(), resolvable.requiredType, resolvable.qualifiers)) continue;
                removedMatching.add(removedBean);
            }
            if (!removedMatching.isEmpty()) {
                String separator = "====================";
                String msg = "\n%1$s%1$s%1$s%1$s\nCDI: programmatic lookup problem detected\n-----------------------------------------\nAt least one bean matched the required type and qualifiers but was marked as unused and removed during build\nRemoved beans:\n\t- %2$s\nRequired type: %3$s\nRequired qualifiers: %4$s\nSolutions:\n\t- Application developers can eliminate false positives via the @Unremovable annotation\n\t- Extensions can eliminate false positives via build items, e.g. using the UnremovableBeanBuildItem\n\t- See also https://quarkus.io/guides/cdi-reference#remove_unused_beans\n\t- Enable the DEBUG log level to see the full stack trace to identify the method that performed the lookup\n%1$s%1$s%1$s%1$s\n";
                LOGGER.warnf(msg, new Object[]{separator, removedMatching.stream().map(Object::toString).collect(Collectors.joining("\n\t- ")), resolvable.requiredType, Arrays.toString(resolvable.qualifiers)});
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder stack = new StringBuilder("\nCDI: programmatic lookup stack trace:\n");
                    for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                        stack.append("\t");
                        stack.append(e.toString());
                        stack.append("\n");
                    }
                    LOGGER.debug((Object)stack);
                }
            }
        }
        return matching;
    }

    List<InjectableBean<?>> getMatchingBeans(String name) {
        ArrayList matching = new ArrayList();
        for (InjectableBean<?> bean : this.beans) {
            if (!name.equals(bean.getName())) continue;
            matching.add(bean);
        }
        return matching;
    }

    private static int compareAlternativeBeans(InjectableBean<?> bean1, InjectableBean<?> bean2) {
        Integer priority1;
        Integer priority2 = bean2.getAlternativePriority();
        if (priority2 == null && bean2.getDeclaringBean() != null) {
            priority2 = bean2.getDeclaringBean().getAlternativePriority();
        }
        if ((priority1 = bean1.getAlternativePriority()) == null && bean1.getDeclaringBean() != null) {
            priority1 = bean1.getDeclaringBean().getAlternativePriority();
        }
        return priority2.compareTo(priority1);
    }

    <T> List<InjectableObserverMethod<? super T>> resolveObservers(Type eventType, Set<Annotation> eventQualifiers) {
        Qualifiers.verify(eventQualifiers);
        if (this.observers.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Type> eventTypes = new HierarchyDiscovery(eventType).getTypeClosure();
        ArrayList<InjectableObserverMethod<T>> resolvedObservers = new ArrayList<InjectableObserverMethod<T>>();
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!EventTypeAssignabilityRules.matches(observer.getObservedType(), eventTypes) || !observer.getObservedQualifiers().isEmpty() && !Qualifiers.isSubset(observer.getObservedQualifiers(), eventQualifiers, this.qualifierNonbindingMembers)) continue;
            resolvedObservers.add(observer);
        }
        resolvedObservers.sort(InjectableObserverMethod::compare);
        return resolvedObservers;
    }

    List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (this.interceptors.isEmpty()) {
            return Collections.emptyList();
        }
        if (interceptorBindings.length == 0) {
            throw new IllegalArgumentException("No interceptor bindings");
        }
        ArrayList interceptors = new ArrayList();
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation binding : interceptorBindings) {
            bindings.add(binding);
            Set<Annotation> transitive = this.transitiveInterceptorBindings.get(binding.annotationType());
            if (transitive == null) continue;
            bindings.addAll(transitive);
        }
        for (InjectableInterceptor injectableInterceptor : this.interceptors) {
            if (!injectableInterceptor.intercepts(type) || !this.hasAllInterceptionBindings(injectableInterceptor, bindings)) continue;
            interceptors.add(injectableInterceptor);
        }
        return interceptors;
    }

    List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... qualifiers) {
        if (this.decorators.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.requireNonNull(types).isEmpty()) {
            throw new IllegalArgumentException("The set of bean types must not be empty");
        }
        ArrayList decorators = new ArrayList();
        for (InjectableDecorator<?> decorator : this.decorators) {
            if (!this.matches(types, Set.of(qualifiers), decorator.getDelegateType(), decorator.getDelegateQualifiers().toArray(new Annotation[0]))) continue;
            decorators.add(decorator);
        }
        return decorators;
    }

    private boolean hasAllInterceptionBindings(InjectableInterceptor<?> interceptor, Iterable<Annotation> bindings) {
        for (Annotation binding : interceptor.getInterceptorBindings()) {
            if (Qualifiers.hasQualifier(bindings, binding, this.qualifierNonbindingMembers)) continue;
            return false;
        }
        return true;
    }

    Set<InjectableBean<?>> getResolvedBeans(Type requiredType, Annotation ... qualifiers) {
        if (qualifiers == null || qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        return this.resolved.getValue(new Resolvable(requiredType, qualifiers));
    }

    private boolean matches(InjectableBean<?> bean, Type requiredType, Annotation ... qualifiers) {
        return this.matches(bean.getTypes(), bean.getQualifiers(), requiredType, qualifiers);
    }

    private boolean matches(Set<Type> beanTypes, Set<Annotation> beanQualifiers, Type requiredType, Annotation ... qualifiers) {
        if (!BeanTypeAssignabilityRules.matches(requiredType, beanTypes)) {
            return false;
        }
        return Qualifiers.hasQualifiers(beanQualifiers, this.qualifierNonbindingMembers, qualifiers);
    }

    static ArcContainerImpl unwrap(ArcContainer container) {
        if (container instanceof ArcContainerImpl) {
            return (ArcContainerImpl)container;
        }
        throw new IllegalArgumentException();
    }

    public static void mockObservers(String beanIdentifier, boolean mock) {
        ArcContainerImpl.instance().mockObserversFor(beanIdentifier, mock);
    }

    private void mockObserversFor(String beanIdentifier, boolean mock) {
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!(observer instanceof Mockable) || !beanIdentifier.equals(observer.getDeclaringBeanIdentifier())) continue;
            Mockable mockable = (Mockable)((Object)observer);
            if (mock) {
                mockable.arc$setMock(null);
                continue;
            }
            mockable.arc$clearMock();
        }
    }

    public void mockObserversFor(Class<?> beanClass, boolean mock) {
        for (InjectableObserverMethod<?> observer : this.observers) {
            if (!(observer instanceof Mockable) || !beanClass.equals(observer.getBeanClass())) continue;
            Mockable mockable = (Mockable)((Object)observer);
            if (mock) {
                mockable.arc$setMock(null);
                continue;
            }
            mockable.arc$clearMock();
        }
    }

    public static ArcContainerImpl instance() {
        return ArcContainerImpl.unwrap(Arc.container());
    }

    private void requireRunning() {
        if (!this.running.get()) {
            throw new IllegalStateException("Container not running: " + this);
        }
    }

    private static final class Resolvable {
        private static final Set<Type> BUILT_IN_TYPES = new HashSet<Class>(Arrays.asList(Event.class, Instance.class));
        private static final Annotation[] ANY_QUALIFIER = new Annotation[]{Any.Literal.INSTANCE};
        final Type requiredType;
        final Annotation[] qualifiers;

        Resolvable(Type requiredType, Annotation[] qualifiers) {
            Class rawType = Reflections.getRawType(requiredType);
            if (BUILT_IN_TYPES.contains(rawType)) {
                this.requiredType = rawType;
                this.qualifiers = ANY_QUALIFIER;
            } else {
                this.requiredType = requiredType;
                this.qualifiers = qualifiers;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.qualifiers);
            result = 31 * result + (this.requiredType == null ? 0 : this.requiredType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Resolvable)) {
                return false;
            }
            Resolvable other = (Resolvable)obj;
            if (this.requiredType == null ? other.requiredType != null : !this.requiredType.equals(other.requiredType)) {
                return false;
            }
            return Arrays.equals(this.qualifiers, other.qualifiers);
        }
    }
}

