/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Supplier;

public class AgroalConnectionFactoryConfigurationSupplier
implements Supplier<AgroalConnectionFactoryConfiguration> {
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    boolean autoCommit = true;
    boolean trackJdbcResources = true;
    String jdbcUrl = "";
    String initialSql = "";
    Class<?> connectionProviderClass;
    AgroalConnectionFactoryConfiguration.IsolationLevel transactionIsolation = AgroalConnectionFactoryConfiguration.TransactionIsolation.UNDEFINED;
    Collection<AgroalSecurityProvider> securityProviders = new ArrayList<AgroalSecurityProvider>();
    Principal principal;
    Collection<Object> credentials = new ArrayList<Object>();
    Principal recoveryPrincipal;
    Collection<Object> recoveryCredentials = new ArrayList<Object>();
    Properties jdbcProperties = new Properties();
    private volatile boolean lock = false;

    public AgroalConnectionFactoryConfigurationSupplier() {
        this.securityProviders.add(new AgroalDefaultSecurityProvider());
        this.securityProviders.add(new AgroalKerberosSecurityProvider());
    }

    public AgroalConnectionFactoryConfigurationSupplier(AgroalConnectionFactoryConfiguration existingConfiguration) {
        this();
        if (existingConfiguration == null) {
            return;
        }
        this.autoCommit = existingConfiguration.autoCommit();
        this.jdbcUrl = existingConfiguration.jdbcUrl();
        this.initialSql = existingConfiguration.initialSql();
        this.connectionProviderClass = existingConfiguration.connectionProviderClass();
        this.transactionIsolation = existingConfiguration.jdbcTransactionIsolation();
        this.principal = existingConfiguration.principal();
        this.credentials = existingConfiguration.credentials();
        this.recoveryPrincipal = existingConfiguration.recoveryPrincipal();
        this.recoveryCredentials = existingConfiguration.recoveryCredentials();
        this.jdbcProperties = existingConfiguration.jdbcProperties();
        this.securityProviders = existingConfiguration.securityProviders();
        this.trackJdbcResources = existingConfiguration.trackJdbcResources();
    }

    private void checkLock() {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
    }

    public AgroalConnectionFactoryConfigurationSupplier autoCommit(boolean autoCommitEnabled) {
        this.checkLock();
        this.autoCommit = autoCommitEnabled;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier trackJdbcResources(boolean trackJdbcResourcesEnabled) {
        this.checkLock();
        this.trackJdbcResources = trackJdbcResourcesEnabled;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcUrl(String jdbcUrlString) {
        this.checkLock();
        this.jdbcUrl = jdbcUrlString;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier initialSql(String initialSqlString) {
        this.checkLock();
        this.initialSql = initialSqlString;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier connectionProviderClass(Class<?> connectionProvider) {
        this.checkLock();
        this.connectionProviderClass = connectionProvider;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier connectionProviderClassName(String connectionProviderName) {
        try {
            this.checkLock();
            this.connectionProviderClass = connectionProviderName == null ? null : Class.forName(connectionProviderName);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + connectionProviderName, e);
        }
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcTransactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolationLevel) {
        this.checkLock();
        this.transactionIsolation = transactionIsolationLevel;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcTransactionIsolation(int customValue) {
        this.checkLock();
        this.transactionIsolation = new CustomIsolationLevel(customValue);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier addSecurityProvider(AgroalSecurityProvider provider) {
        this.checkLock();
        this.securityProviders.add(provider);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier principal(Principal loginPrincipal) {
        this.checkLock();
        this.principal = loginPrincipal;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier credential(Object credential) {
        this.checkLock();
        this.credentials.add(credential);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier recoveryPrincipal(Principal loginPrincipal) {
        this.checkLock();
        this.recoveryPrincipal = loginPrincipal;
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier recoveryCredential(Object credential) {
        this.checkLock();
        this.recoveryCredentials.add(credential);
        return this;
    }

    public AgroalConnectionFactoryConfigurationSupplier jdbcProperty(String key, String value) {
        this.checkLock();
        this.jdbcProperties.setProperty(key, value);
        return this;
    }

    private void validate() {
        if (this.lock) {
            throw new IllegalStateException("Configuration already supplied");
        }
        if (this.jdbcProperties.containsKey(USER_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid JDBC property 'user': use principal instead.");
        }
        if (this.jdbcProperties.containsKey(PASSWORD_PROPERTY_NAME)) {
            throw new IllegalArgumentException("Invalid property 'password': use credential instead.");
        }
    }

    @Override
    public AgroalConnectionFactoryConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalConnectionFactoryConfiguration(){

            @Override
            public boolean autoCommit() {
                return AgroalConnectionFactoryConfigurationSupplier.this.autoCommit;
            }

            @Override
            public boolean trackJdbcResources() {
                return AgroalConnectionFactoryConfigurationSupplier.this.trackJdbcResources;
            }

            @Override
            public String jdbcUrl() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcUrl;
            }

            @Override
            public String initialSql() {
                return AgroalConnectionFactoryConfigurationSupplier.this.initialSql;
            }

            @Override
            public Class<?> connectionProviderClass() {
                return AgroalConnectionFactoryConfigurationSupplier.this.connectionProviderClass;
            }

            @Override
            public AgroalConnectionFactoryConfiguration.IsolationLevel jdbcTransactionIsolation() {
                return AgroalConnectionFactoryConfigurationSupplier.this.transactionIsolation;
            }

            @Override
            public Collection<AgroalSecurityProvider> securityProviders() {
                return AgroalConnectionFactoryConfigurationSupplier.this.securityProviders;
            }

            @Override
            public Principal principal() {
                return AgroalConnectionFactoryConfigurationSupplier.this.principal;
            }

            @Override
            public Collection<Object> credentials() {
                return AgroalConnectionFactoryConfigurationSupplier.this.credentials;
            }

            @Override
            public Principal recoveryPrincipal() {
                return AgroalConnectionFactoryConfigurationSupplier.this.recoveryPrincipal;
            }

            @Override
            public Collection<Object> recoveryCredentials() {
                return AgroalConnectionFactoryConfigurationSupplier.this.recoveryCredentials;
            }

            @Override
            public Properties jdbcProperties() {
                return AgroalConnectionFactoryConfigurationSupplier.this.jdbcProperties;
            }
        };
    }

    private static class CustomIsolationLevel
    implements AgroalConnectionFactoryConfiguration.IsolationLevel {
        private final int customValue;

        public CustomIsolationLevel(int customValue) {
            this.customValue = customValue;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public int level() {
            return this.customValue;
        }

        public String toString() {
            return "CUSTOM";
        }
    }
}

