/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;

public class VehicleRoutingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.vehicleCapacity(constraintFactory), this.distanceFromPreviousStandstill(constraintFactory), this.distanceFromLastVisitToDepot(constraintFactory)};
    }

    Constraint vehicleCapacity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PlanningVisit.class).groupBy(PlanningVisit::getVehicle, ConstraintCollectors.sum(PlanningVisit::getDemand)).filter((vehicle, demand) -> demand > vehicle.getCapacity()).penalizeLong("vehicle capacity", (Score)HardSoftLongScore.ONE_HARD, (vehicle, demand) -> demand - vehicle.getCapacity());
    }

    Constraint distanceFromPreviousStandstill(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PlanningVisit.class).penalizeLong("distance from previous standstill", (Score)HardSoftLongScore.ONE_SOFT, PlanningVisit::distanceFromPreviousStandstill);
    }

    Constraint distanceFromLastVisitToDepot(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(PlanningVisit.class).filter(PlanningVisit::isLast).penalizeLong("distance from last visit to depot", (Score)HardSoftLongScore.ONE_SOFT, PlanningVisit::distanceToDepot);
    }
}

