/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class PathBidirRef
extends Path {
    protected SPTEntry edgeTo;
    private boolean switchFromAndToSPTEntry = false;

    public PathBidirRef(Graph g, Weighting weighting) {
        super(g, weighting);
    }

    PathBidirRef(PathBidirRef p) {
        super(p);
        this.edgeTo = p.edgeTo;
        this.switchFromAndToSPTEntry = p.switchFromAndToSPTEntry;
    }

    public PathBidirRef setSwitchToFrom(boolean b) {
        this.switchFromAndToSPTEntry = b;
        return this;
    }

    public PathBidirRef setSPTEntryTo(SPTEntry edgeTo) {
        this.edgeTo = edgeTo;
        return this;
    }

    @Override
    public Path extract() {
        if (this.sptEntry == null || this.edgeTo == null) {
            return this;
        }
        if (this.sptEntry.adjNode != this.edgeTo.adjNode) {
            throw new IllegalStateException("Locations of the 'to'- and 'from'-Edge have to be the same. " + this.toString() + ", fromEntry:" + this.sptEntry + ", toEntry:" + this.edgeTo);
        }
        this.extractSW.start();
        if (this.switchFromAndToSPTEntry) {
            SPTEntry ee = this.sptEntry;
            this.sptEntry = this.edgeTo;
            this.edgeTo = ee;
        }
        this.extractFwdPath();
        this.processTurnAtMeetingPoint();
        this.extractBwdPath();
        this.extractSW.stop();
        return this.setFound(true);
    }

    private void extractFwdPath() {
        SPTEntry currEdge = this.sptEntry;
        SPTEntry prevEdge = currEdge.parent;
        while (EdgeIterator.Edge.isValid(currEdge.edge)) {
            this.processEdge(currEdge.edge, currEdge.adjNode, this.getIncEdge(prevEdge));
            currEdge = prevEdge;
            prevEdge = currEdge.parent;
        }
        this.setFromNode(currEdge.adjNode);
        this.reverseOrder();
    }

    private void extractBwdPath() {
        SPTEntry currEdge = this.edgeTo;
        SPTEntry nextEdge = currEdge.parent;
        while (EdgeIterator.Edge.isValid(currEdge.edge)) {
            this.processEdgeBwd(currEdge.edge, currEdge.adjNode, this.getIncEdge(nextEdge));
            currEdge = nextEdge;
            nextEdge = nextEdge.parent;
        }
        this.setEndNode(currEdge.adjNode);
    }

    private void processTurnAtMeetingPoint() {
        this.processTurn(this.getIncEdge(this.sptEntry), this.sptEntry.adjNode, this.getIncEdge(this.edgeTo));
    }

    protected void processEdgeBwd(int edgeId, int adjNode, int nextEdgeId) {
        EdgeIteratorState edge = this.graph.getEdgeIteratorState(edgeId, adjNode);
        this.distance += edge.getDistance();
        this.time += this.weighting.calcMillis(edge, true, nextEdgeId);
        this.addEdge(edgeId);
    }

    private void processTurn(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return;
        }
        if (this.weighting instanceof TurnWeighting) {
            this.time = (long)((double)this.time + ((TurnWeighting)this.weighting).calcTurnWeight(inEdge, viaNode, outEdge) * 1000.0);
        }
    }

    protected int getIncEdge(SPTEntry entry) {
        return entry.edge;
    }
}

