/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.Surface;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.List;

public class OSMSurfaceParser
implements TagParser {
    private final EnumEncodedValue<Surface> surfaceEnc;

    public OSMSurfaceParser() {
        this(new EnumEncodedValue<Surface>("surface", Surface.class));
    }

    public OSMSurfaceParser(EnumEncodedValue<Surface> surfaceEnc) {
        this.surfaceEnc = surfaceEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.surfaceEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, EncodingManager.Access access, long relationFlags) {
        String surfaceTag = readerWay.getTag("surface");
        Surface surface = Surface.find(surfaceTag);
        if (surface == Surface.OTHER && !Helper.isEmpty((String)surfaceTag)) {
            if (surfaceTag.equals("paving_stones") || surfaceTag.equals("metal") || surfaceTag.startsWith("concrete")) {
                surface = Surface.PAVED;
            } else if (surfaceTag.equals("sett")) {
                surface = Surface.COBBLESTONE;
            }
        }
        if (surface != Surface.OTHER) {
            this.surfaceEnc.setEnum(false, edgeFlags, surface);
        }
        return edgeFlags;
    }
}

