/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.GraphHopper;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.parsers.SpatialRuleParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.util.spatialrules.CountriesSpatialRuleFactory;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupBuilder;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupHelper {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupHelper.class);

    public static void buildAndInjectSpatialRuleIntoGH(GraphHopper graphHopper, BBox maxBounds, JsonFeatureCollection jsonFeatureCollection) {
        final SpatialRuleLookup index = SpatialRuleLookupBuilder.buildIndex(jsonFeatureCollection, "ISO_A3", new CountriesSpatialRuleFactory(), 0.1, maxBounds);
        logger.info("Set spatial rule lookup with " + index.size() + " rules");
        final TagParserFactory oldTPF = graphHopper.getTagParserFactory();
        graphHopper.setTagParserFactory(new TagParserFactory(){

            @Override
            public TagParser create(String name, PMap configuration) {
                if (name.equals("country")) {
                    return new SpatialRuleParser(index);
                }
                return oldTPF.create(name, configuration);
            }
        });
    }
}

