/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class DecimalDetails
extends AbstractPathDetailsBuilder {
    private final DecimalEncodedValue ev;
    private double decimalValue = -1.0;
    private final String infinityJsonValue;

    public DecimalDetails(String name, DecimalEncodedValue ev) {
        this(name, ev, null);
    }

    public DecimalDetails(String name, DecimalEncodedValue ev, String infinityJsonValue) {
        super(name);
        this.ev = ev;
        this.infinityJsonValue = infinityJsonValue;
    }

    @Override
    protected Object getCurrentValue() {
        if (Double.isInfinite(this.decimalValue)) {
            return this.infinityJsonValue;
        }
        return this.decimalValue;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        double tmpVal = edge.get(this.ev);
        if (Math.abs(tmpVal - this.decimalValue) > 1.0E-4) {
            this.decimalValue = tmpVal;
            return true;
        }
        return false;
    }
}

