/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.Helper;
import com.graphhopper.util.NumHelper;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Shape;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;

public class BBox
implements Shape,
Cloneable {
    private final boolean elevation;
    public double minLon;
    public double maxLon;
    public double minLat;
    public double maxLat;
    public double minEle;
    public double maxEle;

    public BBox(double[] coords) {
        this(coords[0], coords[2], coords[1], coords[3]);
    }

    public BBox(double minLon, double maxLon, double minLat, double maxLat) {
        this(minLon, maxLon, minLat, maxLat, Double.NaN, Double.NaN, false);
    }

    public BBox(double minLon, double maxLon, double minLat, double maxLat, double minEle, double maxEle) {
        this(minLon, maxLon, minLat, maxLat, minEle, maxEle, true);
    }

    public BBox(double minLon, double maxLon, double minLat, double maxLat, double minEle, double maxEle, boolean elevation) {
        this.elevation = elevation;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.minEle = minEle;
        this.maxEle = maxEle;
    }

    public static BBox createInverse(boolean elevation) {
        if (elevation) {
            return new BBox(Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, true);
        }
        return new BBox(Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.NaN, Double.NaN, false);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public void update(double lat, double lon) {
        if (lat > this.maxLat) {
            this.maxLat = lat;
        }
        if (lat < this.minLat) {
            this.minLat = lat;
        }
        if (lon > this.maxLon) {
            this.maxLon = lon;
        }
        if (lon < this.minLon) {
            this.minLon = lon;
        }
    }

    public void update(double lat, double lon, double elev) {
        if (this.elevation) {
            if (elev > this.maxEle) {
                this.maxEle = elev;
            }
            if (elev < this.minEle) {
                this.minEle = elev;
            }
        } else {
            throw new IllegalStateException("No BBox with elevation to update");
        }
        this.update(lat, lon);
    }

    public BBox calculateIntersection(BBox bBox) {
        if (!this.intersects(bBox)) {
            return null;
        }
        double minLon = Math.max(this.minLon, bBox.minLon);
        double maxLon = Math.min(this.maxLon, bBox.maxLon);
        double minLat = Math.max(this.minLat, bBox.minLat);
        double maxLat = Math.min(this.maxLat, bBox.maxLat);
        return new BBox(minLon, maxLon, minLat, maxLat);
    }

    public BBox clone() {
        return new BBox(this.minLon, this.maxLon, this.minLat, this.maxLat, this.minEle, this.maxEle, this.elevation);
    }

    @Override
    public boolean intersects(Shape s) {
        if (s instanceof BBox) {
            return this.intersects((BBox)s);
        }
        if (s instanceof Circle) {
            return ((Circle)s).intersects(this);
        }
        throw new UnsupportedOperationException("unsupported shape");
    }

    @Override
    public boolean contains(Shape s) {
        if (s instanceof BBox) {
            return this.contains((BBox)s);
        }
        if (s instanceof Circle) {
            return this.contains((Circle)s);
        }
        throw new UnsupportedOperationException("unsupported shape");
    }

    public boolean intersects(Circle s) {
        return s.intersects(this);
    }

    public boolean intersects(double minLon, double maxLon, double minLat, double maxLat) {
        return this.minLon < maxLon && this.minLat < maxLat && minLon < this.maxLon && minLat < this.maxLat;
    }

    public boolean intersects(BBox o) {
        return this.minLon < o.maxLon && this.minLat < o.maxLat && o.minLon < this.maxLon && o.minLat < this.maxLat;
    }

    @Override
    public boolean contains(double lat, double lon) {
        return lat <= this.maxLat && lat >= this.minLat && lon <= this.maxLon && lon >= this.minLon;
    }

    public boolean contains(BBox b) {
        return this.maxLat >= b.maxLat && this.minLat <= b.minLat && this.maxLon >= b.maxLon && this.minLon <= b.minLon;
    }

    public boolean contains(Circle c) {
        return this.contains(c.getBounds());
    }

    public String toString() {
        String str = this.minLon + "," + this.maxLon + "," + this.minLat + "," + this.maxLat;
        if (this.elevation) {
            str = str + "," + this.minEle + "," + this.maxEle;
        }
        return str;
    }

    public String toLessPrecisionString() {
        return (float)this.minLon + "," + (float)this.maxLon + "," + (float)this.minLat + "," + (float)this.maxLat;
    }

    @Override
    public BBox getBounds() {
        return this;
    }

    @Override
    public GHPoint getCenter() {
        return new GHPoint((this.maxLat + this.minLat) / 2.0, (this.maxLon + this.minLon) / 2.0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        BBox b = (BBox)obj;
        return NumHelper.equalsEps(this.minLat, b.minLat) && NumHelper.equalsEps(this.maxLat, b.maxLat) && NumHelper.equalsEps(this.minLon, b.minLon) && NumHelper.equalsEps(this.maxLon, b.maxLon);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.minLon) ^ Double.doubleToLongBits(this.minLon) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.maxLon) ^ Double.doubleToLongBits(this.maxLon) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.minLat) ^ Double.doubleToLongBits(this.minLat) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.maxLat) ^ Double.doubleToLongBits(this.maxLat) >>> 32);
        return hash;
    }

    public boolean isValid() {
        if (this.minLon >= this.maxLon) {
            return false;
        }
        if (this.minLat >= this.maxLat) {
            return false;
        }
        if (this.elevation) {
            if (this.minEle > this.maxEle) {
                return false;
            }
            if (Double.compare(this.maxEle, -1.7976931348623157E308) == 0 || Double.compare(this.minEle, Double.MAX_VALUE) == 0) {
                return false;
            }
        }
        return Double.compare(this.maxLat, -1.7976931348623157E308) != 0 && Double.compare(this.minLat, Double.MAX_VALUE) != 0 && Double.compare(this.maxLon, -1.7976931348623157E308) != 0 && Double.compare(this.minLon, Double.MAX_VALUE) != 0;
    }

    public List<Double> toGeoJson() {
        ArrayList<Double> list = new ArrayList<Double>(4);
        list.add(Helper.round6(this.minLon));
        list.add(Helper.round6(this.minLat));
        if (this.elevation) {
            list.add(Helper.round2(this.minEle));
        }
        list.add(Helper.round6(this.maxLon));
        list.add(Helper.round6(this.maxLat));
        if (this.elevation) {
            list.add(Helper.round2(this.maxEle));
        }
        return list;
    }

    public static BBox fromEnvelope(Envelope envelope) {
        return new BBox(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
    }

    @Override
    public double calculateArea() {
        double meanLat = (this.maxLat + this.minLat) / 2.0;
        return Helper.DIST_PLANE.calcDist(meanLat, this.minLon, meanLat, this.maxLon) * Helper.DIST_PLANE.calcDist(this.minLat, this.minLon, this.maxLat, this.minLon);
    }

    public static BBox parseTwoPoints(String objectAsString) {
        double tmp;
        String[] splittedObject = objectAsString.split(",");
        if (splittedObject.length != 4) {
            throw new IllegalArgumentException("BBox should have 4 parts but was " + objectAsString);
        }
        double minLat = Double.parseDouble(splittedObject[0]);
        double minLon = Double.parseDouble(splittedObject[1]);
        double maxLat = Double.parseDouble(splittedObject[2]);
        double maxLon = Double.parseDouble(splittedObject[3]);
        if (minLat > maxLat) {
            tmp = minLat;
            minLat = maxLat;
            maxLat = tmp;
        }
        if (minLon > maxLon) {
            tmp = minLon;
            minLon = maxLon;
            maxLon = tmp;
        }
        return new BBox(minLon, maxLon, minLat, maxLat);
    }

    public static BBox parseBBoxString(String objectAsString) {
        String[] splittedObject = objectAsString.split(",");
        if (splittedObject.length != 4) {
            throw new IllegalArgumentException("BBox should have 4 parts but was " + objectAsString);
        }
        double minLon = Double.parseDouble(splittedObject[0]);
        double maxLon = Double.parseDouble(splittedObject[1]);
        double minLat = Double.parseDouble(splittedObject[2]);
        double maxLat = Double.parseDouble(splittedObject[3]);
        return new BBox(minLon, maxLon, minLat, maxLat);
    }
}

