/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.util.function.Predicate;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;

public final class DroolsExistsBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsAbstractBiConstraintStream<Solution_, A, B> parent;
    private final BiLeftHandSide<A, B> leftHandSide;
    private final String streamName;

    public <C> DroolsExistsBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, boolean shouldExist, boolean shouldIncludeNullVars, Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        Predicate<C> nullityFilter = shouldIncludeNullVars ? null : constraintFactory.getNullityFilter(otherClass);
        this.leftHandSide = shouldExist ? parent.getLeftHandSide().andExists(otherClass, joiners, nullityFilter) : parent.getLeftHandSide().andNotExists(otherClass, joiners, nullityFilter);
        this.streamName = shouldExist ? "BiIfExists()" : "BiIfNotExists()";
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public BiLeftHandSide<A, B> getLeftHandSide() {
        return this.leftHandSide;
    }

    public String toString() {
        return this.streamName + " with " + this.getChildStreams().size() + " children";
    }
}

