/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.monitoring.MonitoringConfig;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.PhaseFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryFactory;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.random.DefaultRandomFactory;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecallerFactory;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.termination.TerminationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverFactory<Solution_>
implements SolverFactory<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverFactory.class);
    private static final long DEFAULT_RANDOM_SEED = 0L;
    private final SolverConfig solverConfig;

    public DefaultSolverFactory(SolverConfig solverConfig) {
        if (solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + solverConfig + ") cannot be null.");
        }
        this.solverConfig = solverConfig;
    }

    public InnerScoreDirectorFactory<Solution_, ?> getScoreDirectorFactory() {
        return this.buildScoreDirectorFactory(this.solverConfig.determineEnvironmentMode());
    }

    @Override
    public Solver<Solution_> buildSolver() {
        EnvironmentMode environmentMode_ = this.solverConfig.determineEnvironmentMode();
        boolean daemon_ = Objects.requireNonNullElse(this.solverConfig.getDaemon(), false);
        RandomFactory randomFactory = this.buildRandomFactory(environmentMode_);
        Integer moveThreadCount_ = new MoveThreadCountResolver().resolveMoveThreadCount(this.solverConfig.getMoveThreadCount());
        InnerScoreDirectorFactory<Solution_, ?> scoreDirectorFactory = this.buildScoreDirectorFactory(environmentMode_);
        boolean constraintMatchEnabledPreference = environmentMode_.isAsserted();
        SolverScope<Solution_> solverScope = new SolverScope<Solution_>();
        MonitoringConfig monitoringConfig = this.solverConfig.determineMetricConfig();
        solverScope.setMonitoringTags(Tags.empty());
        if (!monitoringConfig.getSolverMetricList().isEmpty()) {
            solverScope.setSolverMetricSet(EnumSet.copyOf(monitoringConfig.getSolverMetricList()));
        } else {
            solverScope.setSolverMetricSet(EnumSet.noneOf(SolverMetric.class));
        }
        solverScope.setScoreDirector(scoreDirectorFactory.buildScoreDirector(true, constraintMatchEnabledPreference));
        if ((solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE) || solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE)) && !solverScope.getScoreDirector().isConstraintMatchEnabled()) {
            LOGGER.warn("The metrics [{}, {}] cannot function properly because ConstraintMatches are not supported on the ScoreDirector.", (Object)SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE.getMeterId(), (Object)SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE.getMeterId());
        }
        BestSolutionRecaller bestSolutionRecaller = BestSolutionRecallerFactory.create().buildBestSolutionRecaller(environmentMode_);
        HeuristicConfigPolicy<Solution_> configPolicy = new HeuristicConfigPolicy<Solution_>(environmentMode_, moveThreadCount_, this.solverConfig.getMoveThreadBufferSize(), this.solverConfig.getThreadFactoryClass(), scoreDirectorFactory);
        TerminationConfig terminationConfig_ = this.solverConfig.getTerminationConfig() == null ? new TerminationConfig() : this.solverConfig.getTerminationConfig();
        BasicPlumbingTermination basicPlumbingTermination = new BasicPlumbingTermination(daemon_);
        Termination termination = TerminationFactory.create(terminationConfig_).buildTermination(configPolicy, basicPlumbingTermination);
        List<Phase<Solution_>> phaseList = this.buildPhaseList(configPolicy, bestSolutionRecaller, termination);
        DefaultSolver out = new DefaultSolver(environmentMode_, randomFactory, bestSolutionRecaller, basicPlumbingTermination, termination, phaseList, solverScope, moveThreadCount_ == null ? "NONE" : Integer.toString(moveThreadCount_));
        return out;
    }

    public InnerScoreDirectorFactory<Solution_, ?> buildScoreDirectorFactory(EnvironmentMode environmentMode) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.buildSolutionDescriptor(environmentMode);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig_ = this.solverConfig.getScoreDirectorFactoryConfig() == null ? new ScoreDirectorFactoryConfig() : this.solverConfig.getScoreDirectorFactoryConfig();
        ScoreDirectorFactoryFactory scoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory(scoreDirectorFactoryConfig_);
        return scoreDirectorFactoryFactory.buildScoreDirectorFactory(this.solverConfig.getClassLoader(), environmentMode, solutionDescriptor);
    }

    public SolutionDescriptor<Solution_> buildSolutionDescriptor(EnvironmentMode environmentMode) {
        if (this.solverConfig.getSolutionClass() == null) {
            throw new IllegalArgumentException("The solver configuration must have a solutionClass (" + this.solverConfig.getSolutionClass() + "). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.");
        }
        if (ConfigUtils.isEmptyCollection(this.solverConfig.getEntityClassList())) {
            throw new IllegalArgumentException("The solver configuration must have at least 1 entityClass (" + this.solverConfig.getEntityClassList() + "). If you're using the Quarkus extension or Spring Boot starter, it should have been filled in already.");
        }
        SolutionDescriptor<?> solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(this.solverConfig.determineDomainAccessType(), this.solverConfig.getSolutionClass(), this.solverConfig.getGizmoMemberAccessorMap(), this.solverConfig.getGizmoSolutionClonerMap(), this.solverConfig.getEntityClassList());
        if (environmentMode.isAsserted()) {
            solutionDescriptor.setAssertModelForCloning(true);
        }
        return solutionDescriptor;
    }

    protected RandomFactory buildRandomFactory(EnvironmentMode environmentMode_) {
        RandomFactory randomFactory;
        if (this.solverConfig.getRandomFactoryClass() != null) {
            if (this.solverConfig.getRandomType() != null || this.solverConfig.getRandomSeed() != null) {
                throw new IllegalArgumentException("The solverConfig with randomFactoryClass (" + this.solverConfig.getRandomFactoryClass() + ") has a non-null randomType (" + this.solverConfig.getRandomType() + ") or a non-null randomSeed (" + this.solverConfig.getRandomSeed() + ").");
            }
            randomFactory = ConfigUtils.newInstance(this.solverConfig, "randomFactoryClass", this.solverConfig.getRandomFactoryClass());
        } else {
            RandomType randomType_ = Objects.requireNonNullElse(this.solverConfig.getRandomType(), RandomType.JDK);
            Long randomSeed_ = this.solverConfig.getRandomSeed();
            if (this.solverConfig.getRandomSeed() == null && environmentMode_ != EnvironmentMode.NON_REPRODUCIBLE) {
                randomSeed_ = 0L;
            }
            randomFactory = new DefaultRandomFactory(randomType_, randomSeed_);
        }
        return randomFactory;
    }

    protected List<Phase<Solution_>> buildPhaseList(HeuristicConfigPolicy<Solution_> configPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> termination) {
        List<PhaseConfig> phaseConfigList_ = this.solverConfig.getPhaseConfigList();
        if (ConfigUtils.isEmptyCollection(phaseConfigList_)) {
            phaseConfigList_ = Arrays.asList(new ConstructionHeuristicPhaseConfig(), new LocalSearchPhaseConfig());
        }
        ArrayList<Phase<Solution_>> phaseList = new ArrayList<Phase<Solution_>>(phaseConfigList_.size());
        int phaseIndex = 0;
        for (PhaseConfig phaseConfig : phaseConfigList_) {
            PhaseFactory<Solution_> phaseFactory = PhaseFactory.create(phaseConfig);
            Phase phase = phaseFactory.buildPhase(phaseIndex, configPolicy, bestSolutionRecaller, termination);
            phaseList.add(phase);
            ++phaseIndex;
        }
        return phaseList;
    }

    protected static class MoveThreadCountResolver {
        protected MoveThreadCountResolver() {
        }

        protected Integer resolveMoveThreadCount(String moveThreadCount) {
            Integer resolvedMoveThreadCount;
            int availableProcessorCount = this.getAvailableProcessors();
            if (moveThreadCount == null || moveThreadCount.equals("NONE")) {
                return null;
            }
            if (moveThreadCount.equals("AUTO")) {
                resolvedMoveThreadCount = availableProcessorCount - 2;
                if (resolvedMoveThreadCount > 4) {
                    resolvedMoveThreadCount = 4;
                }
                if (resolvedMoveThreadCount <= 1) {
                    return null;
                }
            } else {
                resolvedMoveThreadCount = ConfigUtils.resolvePoolSize("moveThreadCount", moveThreadCount, "NONE", "AUTO");
            }
            if (resolvedMoveThreadCount < 1) {
                throw new IllegalArgumentException("The moveThreadCount (" + moveThreadCount + ") resulted in a resolvedMoveThreadCount (" + resolvedMoveThreadCount + ") that is lower than 1.");
            }
            if (resolvedMoveThreadCount > availableProcessorCount) {
                LOGGER.warn("The resolvedMoveThreadCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedMoveThreadCount, (Object)availableProcessorCount);
            }
            return resolvedMoveThreadCount;
        }

        protected int getAvailableProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }
}

