/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;

public class OverlappedByEvaluatorDefinition
implements EvaluatorDefinition {
    public static final String overlappedbyOp = "overlappedby";
    public static Operator OVERLAPPED_BY;
    public static Operator NOT_OVERLAPPED_BY;
    private static String[] SUPPORTED_IDS;
    private Map<String, OverlappedByEvaluator> cache = Collections.emptyMap();

    public OverlappedByEvaluatorDefinition() {
        OverlappedByEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(overlappedbyOp, false) == null) {
            OVERLAPPED_BY = Operator.addOperatorToRegistry(overlappedbyOp, false);
            NOT_OVERLAPPED_BY = Operator.addOperatorToRegistry(overlappedbyOp, true);
            SUPPORTED_IDS = new String[]{overlappedbyOp};
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        OverlappedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, OverlappedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse(parameterText);
            eval = new OverlappedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class OverlappedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long minDev;
        private long maxDev;
        private String paramText;

        public OverlappedByEvaluator() {
            OverlappedByEvaluatorDefinition.init();
        }

        public OverlappedByEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? NOT_OVERLAPPED_BY : OVERLAPPED_BY);
            OverlappedByEvaluatorDefinition.init();
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.minDev = in.readLong();
            this.maxDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.minDev);
            out.writeLong(this.maxDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, Long.MAX_VALUE);
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'overlappedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(reteEvaluator, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long leftEndTS = ((EventFactHandle)left).getEndTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)left).getStartTimestamp() < rightStartTS && leftEndTS < ((VariableRestriction.TemporalVariableContextEntry)context).endTS && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(reteEvaluator, right.getObject())) {
                return false;
            }
            long leftEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long rightStartTS = ((EventFactHandle)right).getStartTimestamp();
            long dist = leftEndTS - rightStartTS;
            return this.getOperator().isNegated() ^ (((VariableRestriction.TemporalVariableContextEntry)context).startTS < rightStartTS && leftEndTS < ((EventFactHandle)right).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            if (extractor1.isNullValue(reteEvaluator, handle1.getObject()) || extractor2.isNullValue(reteEvaluator, handle2.getObject())) {
                return false;
            }
            long startTS = ((EventFactHandle)handle1).getStartTimestamp();
            long endTS = ((EventFactHandle)handle2).getEndTimestamp();
            long dist = endTS - startTS;
            return this.getOperator().isNegated() ^ (((EventFactHandle)handle2).getStartTimestamp() < startTS && endTS < ((EventFactHandle)handle1).getEndTimestamp() && dist >= this.minDev && dist <= this.maxDev);
        }

        @Override
        public String toString() {
            return "overlappedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.maxDev ^ this.maxDev >>> 32);
            result = 31 * result + (int)(this.minDev ^ this.minDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OverlappedByEvaluator other = (OverlappedByEvaluator)obj;
            return this.maxDev == other.maxDev && this.minDev == other.minDev;
        }

        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.minDev = 1L;
                this.maxDev = Long.MAX_VALUE;
            } else if (parameters.length == 1) {
                this.minDev = 1L;
                this.maxDev = parameters[0];
            } else if (parameters.length == 2) {
                this.minDev = parameters[0];
                this.maxDev = parameters[1];
            } else {
                throw new RuntimeException("[Overlaps Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
            }
        }
    }
}

