/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;

public abstract class PointInTimeEvaluator
extends BaseEvaluator {
    protected long initRange;
    protected long finalRange;
    protected String paramText;
    protected boolean unwrapLeft;
    protected boolean unwrapRight;

    public PointInTimeEvaluator() {
    }

    public PointInTimeEvaluator(ValueType type, Operator operator, long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
        super(type, operator);
        this.paramText = paramText;
        this.unwrapLeft = unwrapLeft;
        this.unwrapRight = unwrapRight;
        this.setParameters(parameters);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.initRange = in.readLong();
        this.finalRange = in.readLong();
        this.paramText = (String)in.readObject();
        this.unwrapLeft = in.readBoolean();
        this.unwrapRight = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.initRange);
        out.writeLong(this.finalRange);
        out.writeObject(this.paramText);
        out.writeBoolean(this.unwrapLeft);
        out.writeBoolean(this.unwrapRight);
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    protected abstract boolean evaluate(long var1, long var3);

    protected abstract long getLeftTimestamp(InternalFactHandle var1);

    protected abstract long getRightTimestamp(InternalFactHandle var1);

    private long getTimestamp(FieldValue value) {
        Object obj = value.getValue();
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return PointInTimeEvaluator.getTimestampFromDate(obj);
    }

    public static long getTimestampFromDate(Object obj) {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        try {
            if (obj instanceof LocalDate) {
                return ((LocalDate)obj).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            if (obj instanceof LocalDateTime) {
                return ((LocalDateTime)obj).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            if (obj instanceof ZonedDateTime) {
                return ((ZonedDateTime)obj).toInstant().toEpochMilli();
            }
            if (obj instanceof Instant) {
                return ((Instant)obj).toEpochMilli();
            }
        }
        catch (ArithmeticException ae) {
            throw new RuntimeException("Cannot convert " + obj.getClass().getSimpleName() + " '" + obj + "' into a long value");
        }
        throw new RuntimeException("Cannot extract timestamp from " + obj);
    }

    @Override
    public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
        long rightTS = extractor.isSelfReference() ? this.getRightTimestamp(object1) : extractor.getLongValue(reteEvaluator, object1.getObject());
        long leftTS = this.getTimestamp(object2);
        return this.evaluate(rightTS, leftTS);
    }

    @Override
    public boolean evaluateCachedLeft(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
        if (context.leftNull || context.extractor.isNullValue(reteEvaluator, right.getObject())) {
            return false;
        }
        long leftTS = ((VariableRestriction.TimestampedContextEntry)context).timestamp;
        long rightTS = context.getFieldExtractor().isSelfReference() ? this.getRightTimestamp(right) : context.getFieldExtractor().getLongValue(reteEvaluator, right.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    @Override
    public boolean evaluateCachedRight(ReteEvaluator reteEvaluator, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
        if (context.rightNull || context.declaration.getExtractor().isNullValue(reteEvaluator, left.getObject())) {
            return false;
        }
        long rightTS = ((VariableRestriction.TimestampedContextEntry)context).timestamp;
        long leftTS = context.declaration.getExtractor().isSelfReference() ? this.getLeftTimestamp(left) : context.declaration.getExtractor().getLongValue(reteEvaluator, left.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    @Override
    public boolean evaluate(ReteEvaluator reteEvaluator, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
        if (extractor1.isNullValue(reteEvaluator, handle1.getObject()) || extractor2.isNullValue(reteEvaluator, handle2.getObject())) {
            return false;
        }
        long rightTS = extractor1.isSelfReference() ? this.getRightTimestamp(handle1) : extractor1.getLongValue(reteEvaluator, handle1.getObject());
        long leftTS = extractor2.isSelfReference() ? this.getLeftTimestamp(handle2) : extractor2.getLongValue(reteEvaluator, handle2.getObject());
        return this.evaluate(rightTS, leftTS);
    }

    private void setParameters(long[] parameters) {
        if (parameters == null || parameters.length == 0) {
            this.initRange = 1L;
            this.finalRange = Long.MAX_VALUE;
        } else if (parameters.length == 1) {
            this.initRange = parameters[0];
            this.finalRange = Long.MAX_VALUE;
        } else if (parameters.length == 2) {
            if (parameters[0] <= parameters[1]) {
                this.initRange = parameters[0];
                this.finalRange = parameters[1];
            } else {
                this.initRange = parameters[1];
                this.finalRange = parameters[0];
            }
        } else {
            throw new RuntimeException("[PointInTimeEvaluator Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
        }
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
        result = 31 * result + (int)(this.initRange ^ this.initRange >>> 32);
        result = 31 * result + (this.paramText == null ? 0 : this.paramText.hashCode());
        result = 31 * result + (this.unwrapLeft ? 1231 : 1237);
        result = 31 * result + (this.unwrapRight ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointInTimeEvaluator other = (PointInTimeEvaluator)obj;
        if (this.finalRange != other.finalRange) {
            return false;
        }
        if (this.initRange != other.initRange) {
            return false;
        }
        if (this.paramText == null ? other.paramText != null : !this.paramText.equals(other.paramText)) {
            return false;
        }
        return this.unwrapLeft == other.unwrapLeft && this.unwrapRight == other.unwrapRight;
    }

    @Override
    public String toString() {
        return this.getOperator().toString() + "[" + this.paramText + "]";
    }
}

