/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.SegmentMemory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ConcurrentNodeMemories
implements NodeMemories {
    private AtomicReferenceArray<Memory> memories;
    private final Lock lock = new ReentrantLock();
    private final InternalKnowledgeBase kBase;

    public ConcurrentNodeMemories(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.memories = new AtomicReferenceArray(this.kBase.getMemoryCount());
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        if (this.peekNodeMemory(node.getMemoryId()) != null) {
            this.memories.set(node.getMemoryId(), null);
        }
    }

    @Override
    public void clear() {
        this.memories = new AtomicReferenceArray(this.kBase.getMemoryCount());
    }

    @Override
    public void resetAllMemories(StatefulKnowledgeSession session) {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)session.getKieBase();
        HashSet<SegmentMemory> smemSet = new HashSet<SegmentMemory>();
        for (int i = 0; i < this.memories.length(); ++i) {
            Memory memory = this.memories.get(i);
            if (memory == null) continue;
            memory.reset();
            smemSet.add(memory.getSegmentMemory());
        }
        smemSet.forEach(smem -> this.resetSegmentMemory(session, kBase, (SegmentMemory)smem));
    }

    private void resetSegmentMemory(StatefulKnowledgeSession session, InternalKnowledgeBase kBase, SegmentMemory smem) {
        if (smem != null) {
            smem.reset(kBase.getSegmentPrototype(smem));
            if (smem.isSegmentLinked()) {
                smem.notifyRuleLinkSegment((InternalWorkingMemory)session);
            }
        }
    }

    public Memory getNodeMemory(MemoryFactory node, ReteEvaluator reteEvaluator) {
        Memory memory;
        if (node.getMemoryId() >= this.memories.length()) {
            this.resize(node);
        }
        if ((memory = this.memories.get(node.getMemoryId())) == null) {
            memory = this.createNodeMemory(node, reteEvaluator);
        }
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory createNodeMemory(MemoryFactory node, ReteEvaluator reteEvaluator) {
        try {
            this.lock.lock();
            Memory memory = this.memories.get(node.getMemoryId());
            if (memory == null) {
                memory = node.createMemory(this.kBase.getConfiguration(), reteEvaluator);
                if (!this.memories.compareAndSet(node.getMemoryId(), null, memory)) {
                    memory = this.memories.get(node.getMemoryId());
                }
            }
            Memory memory2 = memory;
            return memory2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(MemoryFactory node) {
        try {
            this.lock.lock();
            if (node.getMemoryId() >= this.memories.length()) {
                int size = Math.max(this.kBase.getMemoryCount(), node.getMemoryId() + 32);
                AtomicReferenceArray<Memory> newMem = new AtomicReferenceArray<Memory>(size);
                for (int i = 0; i < this.memories.length(); ++i) {
                    newMem.set(i, this.memories.get(i));
                }
                this.memories = newMem;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Memory peekNodeMemory(int memoryId) {
        if (memoryId < this.memories.length()) {
            return this.memories.get(memoryId);
        }
        return null;
    }

    @Override
    public int length() {
        return this.memories.length();
    }
}

