/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;

public class Rete
extends ObjectSource
implements ObjectSink {
    private static final long serialVersionUID = 510L;
    private Map<EntryPointId, EntryPointNode> entryPoints = Collections.synchronizedMap(new HashMap());
    private transient InternalKnowledgeBase kBase;

    public Rete() {
        this(null);
    }

    public Rete(InternalKnowledgeBase kBase) {
        super(0, RuleBasePartitionId.MAIN_PARTITION, kBase != null && kBase.getConfiguration().isMultithreadEvaluation());
        this.kBase = kBase;
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public short getType() {
        return 20;
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, ReteEvaluator reteEvaluator) {
        EntryPointId entryPoint = context.getEntryPoint();
        EntryPointNode node = this.entryPoints.get(entryPoint);
        ObjectTypeConf typeConf = reteEvaluator.getEntryPoint(entryPoint.getEntryPointId()).getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(entryPoint, factHandle.getObject());
        node.assertObject(factHandle, context, typeConf, reteEvaluator);
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, ReteEvaluator reteEvaluator) {
        EntryPointId entryPoint = context.getEntryPoint();
        EntryPointNode node = this.entryPoints.get(entryPoint);
        ObjectTypeConf typeConf = reteEvaluator.getEntryPoint(entryPoint.getEntryPointId()).getObjectTypeConfigurationRegistry().getObjectTypeConf(handle.getObject());
        node.retractObject(handle, context, typeConf, reteEvaluator);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        EntryPointNode node = (EntryPointNode)objectSink;
        this.entryPoints.put(node.getEntryPoint(), node);
        this.kBase.registerAddedEntryNodeCache(node);
    }

    @Override
    public void removeObjectSink(ObjectSink objectSink) {
        EntryPointNode node = (EntryPointNode)objectSink;
        this.entryPoints.remove(node.getEntryPoint());
        this.kBase.registeRremovedEntryNodeCache(node);
    }

    @Override
    public void doAttach(BuildContext context) {
        throw new UnsupportedOperationException("cannot call attach() from the root Rete node");
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        return false;
    }

    public EntryPointNode getEntryPointNode(EntryPointId entryPoint) {
        return this.entryPoints.get(entryPoint);
    }

    public List<ObjectTypeNode> getObjectTypeNodes() {
        ArrayList<ObjectTypeNode> allNodes = new ArrayList<ObjectTypeNode>();
        for (EntryPointNode node : this.entryPoints.values()) {
            allNodes.addAll(node.getObjectTypeNodes().values());
        }
        return allNodes;
    }

    public Map<ObjectType, ObjectTypeNode> getObjectTypeNodes(EntryPointId entryPoint) {
        return this.entryPoints.get(entryPoint).getObjectTypeNodes();
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    private int calculateHashCode() {
        return this.entryPoints.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Rete) || this.hashCode() != object.hashCode()) {
            return false;
        }
        return this.entryPoints.equals(((Rete)object).entryPoints);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory wm) {
    }

    public Map<EntryPointId, EntryPointNode> getEntryPointNodes() {
        return this.entryPoints;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        throw new UnsupportedOperationException("This should never get called, as the PropertyReactive first happens at the AlphaNode");
    }

    @Override
    public BitMask calculateDeclaredMask(Class modifiedClass, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }
}

