/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import org.drools.core.ActivationListenerFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.time.impl.Timer;

public class NamedConsequenceBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        NamedConsequence namedConsequence = (NamedConsequence)rce;
        Timer timer = context.getRule().getTimer();
        if (timer != null) {
            ReteooComponentBuilder builder = utils.getBuilderFor(Timer.class);
            builder.build(context, utils, context.getRule().getTimer());
        }
        RuleTerminalNode terminalNode = NamedConsequenceBuilder.buildTerminalNodeForNamedConsequence(context, namedConsequence);
        terminalNode.attach(context);
        terminalNode.networkUpdated(new UpdateContext());
        context.getNodes().add(terminalNode);
        if (timer != null) {
            context.setTupleSource(context.getTupleSource().getLeftTupleSource());
        }
        context.setTerminated(namedConsequence.isTerminal());
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return false;
    }

    static RuleTerminalNode buildTerminalNodeForNamedConsequence(BuildContext context, NamedConsequence namedConsequence) {
        RuleImpl rule = context.getRule();
        GroupElement subrule = (GroupElement)context.peek();
        ActivationListenerFactory factory = context.getKnowledgeBase().getConfiguration().getActivationListenerFactory(rule.getActivationListener());
        context.setConsequenceName(namedConsequence.getConsequenceName());
        TerminalNode terminal = factory.createActivationListener(context.getNextNodeId(), context.getTupleSource(), rule, subrule, 0, context, new Object[0]);
        context.setConsequenceName(null);
        return (RuleTerminalNode)terminal;
    }
}

