/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadClass;
import com.graphhopper.routing.profiles.RoadEnvironment;
import com.graphhopper.routing.profiles.UnsignedDecimalEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.GenericWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlagEncoder
extends AbstractFlagEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(DataFlagEncoder.class);
    private static final Map<String, Double> DEFAULT_SPEEDS = new LinkedHashMap<String, Double>(){
        {
            this.put("motorway", 100.0);
            this.put("motorway_link", 70.0);
            this.put("motorroad", 90.0);
            this.put("trunk", 70.0);
            this.put("trunk_link", 65.0);
            this.put("primary", 65.0);
            this.put("primary_link", 60.0);
            this.put("secondary", 60.0);
            this.put("secondary_link", 50.0);
            this.put("tertiary", 50.0);
            this.put("tertiary_link", 40.0);
            this.put("unclassified", 30.0);
            this.put("residential", 30.0);
            this.put("living_street", 5.0);
            this.put("service", 20.0);
            this.put("road", 20.0);
            this.put("forestry", 15.0);
            this.put("track", 15.0);
        }
    };
    private EnumEncodedValue<RoadEnvironment> roadEnvironmentEnc;

    public DataFlagEncoder() {
        this(5, 5.0, 0);
    }

    public DataFlagEncoder(PMap properties) {
        this((int)properties.getLong("speed_bits", 5L), properties.getDouble("speed_factor", 5.0), properties.getBool("turn_costs", false) ? 1 : 0);
        this.properties = properties;
    }

    public DataFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.maxPossibleSpeed = 150;
        this.restrictions.addAll(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        for (String key : Arrays.asList("road_class", "road_environment", "road_access", "max_speed")) {
            if (this.encodedValueLookup.hasEncodedValue(key)) continue;
            throw new IllegalStateException("To use DataFlagEncoder and the GenericWeighting you need to add the encoded value " + key + " before this '" + this.toString() + "' flag encoder. Order is important! E.g. use the config: graph.encoded_values: " + key);
        }
        this.speedEncoder = new UnsignedDecimalEncodedValue("fake", 1, 1.0, false);
        this.roadEnvironmentEnc = this.getEnumEncodedValue("road_environment", RoadEnvironment.class);
    }

    @Override
    protected void flagsDefault(IntsRef edgeFlags, boolean forward, boolean backward) {
        this.accessEnc.setBool(false, edgeFlags, forward);
        this.accessEnc.setBool(true, edgeFlags, backward);
    }

    @Override
    public long handleRelationTags(long oldRelationFlags, ReaderRelation relation) {
        return oldRelationFlags;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        if (this.getRoadClass(way) == RoadClass.OTHER) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    RoadClass getRoadClass(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        RoadClass rc = RoadClass.find(highwayValue);
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return RoadClass.OTHER;
        }
        if (rc == RoadClass.OTHER && way.hasTag("route", (Set<String>)this.ferries)) {
            String motorcarTag = way.getTag("motorcar");
            if (motorcarTag == null) {
                motorcarTag = way.getTag("motor_vehicle");
            }
            if (motorcarTag == null && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0]) || "yes".equals(motorcarTag)) {
                rc = RoadClass.find(way.getTag("ferry"));
            }
        }
        return rc;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        try {
            boolean isOneway;
            RoadClass hwValue = this.getRoadClass(way);
            if (hwValue == RoadClass.OTHER) {
                return edgeFlags;
            }
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            boolean bl = isOneway = way.hasTag("oneway", (Set<String>)this.oneways) || way.hasTag("vehicle:backward", new String[0]) || way.hasTag("vehicle:forward", new String[0]) || way.hasTag("motor_vehicle:backward", new String[0]) || way.hasTag("motor_vehicle:forward", new String[0]);
            if (isOneway || isRoundabout) {
                boolean isBackward;
                boolean bl2 = isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Object)"no") || way.hasTag("motor_vehicle:forward", (Object)"no");
                if (isBackward) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                } else {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
            return edgeFlags;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while parsing way " + way.toString(), ex);
        }
    }

    @Override
    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        throw new RuntimeException("do not call setSpeed");
    }

    @Override
    double getSpeed(boolean reverse, IntsRef flags) {
        throw new UnsupportedOperationException("Calculate speed via more customizable Weighting.calcMillis method");
    }

    @Override
    protected double getMaxSpeed(ReaderWay way) {
        throw new RuntimeException("do not call getMaxSpeed(ReaderWay)");
    }

    @Override
    public double getMaxSpeed() {
        throw new RuntimeException("do not call getMaxSpeed");
    }

    public double getMaxPossibleSpeed() {
        return this.maxPossibleSpeed;
    }

    @Override
    public boolean supports(Class<?> feature) {
        boolean ret = super.supports(feature);
        if (ret) {
            return true;
        }
        return GenericWeighting.class.isAssignableFrom(feature);
    }

    @Override
    public InstructionAnnotation getAnnotation(IntsRef flags, Translation tr) {
        if (this.roadEnvironmentEnc.getEnum(false, flags) == RoadEnvironment.FORD) {
            return new InstructionAnnotation(1, tr.tr("way_contains_ford", new Object[0]));
        }
        return super.getAnnotation(flags, tr);
    }

    @Override
    public int getVersion() {
        return 4;
    }

    public String toString() {
        return "generic";
    }

    public WeightingConfig createWeightingConfig(PMap pMap) {
        HashMap<String, Double> customSpeedMap = new HashMap<String, Double>(DEFAULT_SPEEDS.size());
        double[] speedArray = new double[DEFAULT_SPEEDS.size()];
        for (Map.Entry<String, Double> e : DEFAULT_SPEEDS.entrySet()) {
            double val = pMap.getDouble(e.getKey(), e.getValue().doubleValue());
            customSpeedMap.put(e.getKey(), val);
            RoadClass rc = RoadClass.find(e.getKey());
            speedArray[rc.ordinal()] = val;
        }
        return new WeightingConfig(this.getEnumEncodedValue("road_class", RoadClass.class), speedArray);
    }

    public static class WeightingConfig {
        private final double[] speedArray;
        private final EnumEncodedValue<RoadClass> roadClassEnc;

        public WeightingConfig(EnumEncodedValue<RoadClass> roadClassEnc, double[] speedArray) {
            this.roadClassEnc = roadClassEnc;
            this.speedArray = speedArray;
        }

        public double getSpeed(EdgeIteratorState edgeState) {
            RoadClass rc = edgeState.get(this.roadClassEnc);
            if (rc.ordinal() >= this.speedArray.length) {
                throw new IllegalStateException("RoadClass not found in speed map " + (Object)((Object)rc));
            }
            return this.speedArray[rc.ordinal()];
        }

        public double getMaxSpecifiedSpeed() {
            double tmpSpeed = 0.0;
            for (double speed : this.speedArray) {
                if (!(speed > tmpSpeed)) continue;
                tmpSpeed = speed;
            }
            return tmpSpeed;
        }
    }
}

