/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadClass;
import com.graphhopper.routing.profiles.RoadEnvironment;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.EdgeIteratorState;
import java.util.List;

public class SnapPreventionEdgeFilter
implements EdgeFilter {
    private final EnumEncodedValue<RoadEnvironment> reEnc;
    private final EnumEncodedValue<RoadClass> rcEnc;
    private final EdgeFilter filter;
    private boolean avoidMotorway = false;
    private boolean avoidTrunk;
    private boolean avoidTunnel;
    private boolean avoidBridge;
    private boolean avoidFerry;
    private boolean avoidFord;

    public SnapPreventionEdgeFilter(EdgeFilter filter, EnumEncodedValue<RoadClass> rcEnc, EnumEncodedValue<RoadEnvironment> reEnc, List<String> snapPreventions) {
        this.filter = filter;
        this.reEnc = reEnc;
        this.rcEnc = rcEnc;
        for (String roadClassOrRoadEnv : snapPreventions) {
            if ("motorway".equals(roadClassOrRoadEnv)) {
                this.avoidMotorway = true;
                continue;
            }
            if ("trunk".equals(roadClassOrRoadEnv)) {
                this.avoidTrunk = true;
                continue;
            }
            RoadEnvironment rc = RoadEnvironment.find(roadClassOrRoadEnv);
            if (rc == RoadEnvironment.TUNNEL) {
                this.avoidTunnel = true;
                continue;
            }
            if (rc == RoadEnvironment.BRIDGE) {
                this.avoidBridge = true;
                continue;
            }
            if (rc == RoadEnvironment.FERRY) {
                this.avoidFerry = true;
                continue;
            }
            if (rc == RoadEnvironment.FORD) {
                this.avoidFord = true;
                continue;
            }
            throw new IllegalArgumentException("Cannot find snap_prevention: " + roadClassOrRoadEnv);
        }
    }

    @Override
    public boolean accept(EdgeIteratorState edgeState) {
        return !(!this.filter.accept(edgeState) || this.avoidMotorway && edgeState.get(this.rcEnc) == RoadClass.MOTORWAY || this.avoidTrunk && edgeState.get(this.rcEnc) == RoadClass.TRUNK || this.avoidTunnel && edgeState.get(this.reEnc) == RoadEnvironment.TUNNEL || this.avoidBridge && edgeState.get(this.reEnc) == RoadEnvironment.BRIDGE || this.avoidFord && edgeState.get(this.reEnc) == RoadEnvironment.FORD || this.avoidFerry && edgeState.get(this.reEnc) == RoadEnvironment.FERRY);
    }
}

