/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostExtension;
import java.util.Arrays;
import java.util.Collections;

public class GraphBuilder {
    private final EncodingManager encodingManager;
    private String location;
    private boolean mmap;
    private boolean store;
    private boolean elevation;
    private boolean turnCosts;
    private boolean edgeBasedCH;
    private long byteCapacity = 100L;
    private Weighting singleCHWeighting;

    public GraphBuilder(EncodingManager encodingManager) {
        this.encodingManager = encodingManager;
    }

    public GraphBuilder setCHGraph(Weighting singleCHWeighting) {
        this.singleCHWeighting = singleCHWeighting;
        return this;
    }

    public GraphBuilder setLocation(String location) {
        this.location = location;
        return this;
    }

    public GraphBuilder setStore(boolean store) {
        this.store = store;
        return this;
    }

    public GraphBuilder setMmap(boolean mmap) {
        this.mmap = mmap;
        return this;
    }

    public GraphBuilder setExpectedSize(byte cap) {
        this.byteCapacity = cap;
        return this;
    }

    public GraphBuilder set3D(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GraphBuilder withTurnCosts(boolean turnCosts) {
        this.turnCosts = turnCosts;
        return this;
    }

    public GraphBuilder setEdgeBasedCH(boolean edgeBasedCH) {
        this.edgeBasedCH = edgeBasedCH;
        return this;
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public CHGraph chGraphCreate(Weighting singleCHWeighting) {
        return this.setCHGraph(singleCHWeighting).create().getGraph(CHGraph.class, singleCHWeighting);
    }

    public GraphHopperStorage build() {
        GraphExtension graphExtension;
        GHDirectory dir = this.mmap ? new MMapDirectory(this.location) : new RAMDirectory(this.location, this.store);
        GraphExtension graphExtension2 = graphExtension = this.encodingManager.needsTurnCostsSupport() || this.turnCosts ? new TurnCostExtension() : new GraphExtension.NoOpExtension();
        return this.singleCHWeighting == null ? new GraphHopperStorage(dir, this.encodingManager, this.elevation, graphExtension) : (this.edgeBasedCH ? new GraphHopperStorage(Collections.emptyList(), Arrays.asList(this.singleCHWeighting), dir, this.encodingManager, this.elevation, graphExtension) : new GraphHopperStorage(Arrays.asList(this.singleCHWeighting), Collections.emptyList(), dir, this.encodingManager, this.elevation, graphExtension));
    }

    public GraphHopperStorage create() {
        return this.build().create(this.byteCapacity);
    }

    public GraphHopperStorage load() {
        GraphHopperStorage gs = this.build();
        if (!gs.loadExisting()) {
            throw new IllegalStateException("Cannot load graph " + this.location);
        }
        return gs;
    }
}

