/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.audit;

import org.drools.core.WorkingMemory;
import org.drools.core.audit.event.LogEvent;
import org.drools.kiesession.audit.WorkingMemoryFileLogger;
import org.kie.api.event.KieRuntimeEventManager;

public class ThreadedWorkingMemoryFileLogger
extends WorkingMemoryFileLogger {
    private int interval = 1000;
    private Writer writer;

    public ThreadedWorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        this.setSplit(false);
    }

    public ThreadedWorkingMemoryFileLogger(KieRuntimeEventManager session) {
        super(session);
        this.setSplit(false);
    }

    public void start(int interval) {
        this.interval = interval;
        this.writer = new Writer();
        new Thread(this.writer).start();
    }

    @Override
    public void stop() {
        this.writer.interrupt();
        super.stop();
    }

    @Override
    public synchronized void logEventCreated(LogEvent logEvent) {
        super.logEventCreated(logEvent);
    }

    @Override
    public synchronized void writeToDisk() {
        super.writeToDisk();
    }

    private class Writer
    implements Runnable {
        private boolean interrupt = false;

        private Writer() {
        }

        @Override
        public void run() {
            while (!this.interrupt) {
                try {
                    Thread.sleep(ThreadedWorkingMemoryFileLogger.this.interval);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ThreadedWorkingMemoryFileLogger.this.writeToDisk();
            }
        }

        public void interrupt() {
            this.interrupt = true;
        }
    }
}

