/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.session;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.drools.core.QueryResultsImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.base.StandardQueryViewChangedEventListener;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.EndOperationListener;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectStoreWrapper;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EntryPointsManager;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.RuleBase;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.runtime.rule.impl.LiveQueryImpl;
import org.drools.core.runtime.rule.impl.OpenQueryViewChangedEventListenerAdapter;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AsyncExceptionHandler;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.drools.core.util.bitmask.BitMask;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.ProcessRuntimeFactory;
import org.drools.kiesession.session.StatefulSessionPool;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessEventManager;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.internal.runtime.beliefs.Mode;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.ViewChangedEventListener;
import org.kie.api.time.SessionClock;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class StatefulKnowledgeSessionImpl
extends AbstractRuntime
implements StatefulKnowledgeSession,
WorkingMemoryEntryPoint,
InternalKnowledgeRuntime,
KieSession,
KieRuntimeEventManager,
InternalWorkingMemoryActions,
EventSupport,
RuleEventManager,
ProcessEventManager,
CorrelationAwareProcessRuntime,
Externalizable {
    public static final String ERRORMSG = "Illegal method call. This session was previously disposed.";
    public static final String DEFAULT_RULE_UNIT = "DEFAULT_RULE_UNIT";
    private static final long serialVersionUID = 510L;
    public byte[] bytes;
    protected Long id;
    private NodeMemories nodeMemories;
    protected GlobalResolver globalResolver;
    protected Calendars calendars;
    protected RuleRuntimeEventSupport ruleRuntimeEventSupport;
    protected RuleEventListenerSupport ruleEventListenerSupport;
    protected AgendaEventSupport agendaEventSupport;
    protected List<KieBaseEventListener> kieBaseEventListeners;
    protected transient InternalKnowledgeBase kBase;
    protected FactHandleFactory handleFactory;
    protected InternalAgenda agenda;
    protected ReentrantLock lock;
    private AtomicLong propagationIdCounter;
    private boolean sequential;
    private WorkItemManager workItemManager;
    private TimerService timerService;
    protected InternalFactHandle initialFactHandle;
    private PropagationContextFactory pctxFactory;
    protected SessionConfiguration config;
    private Map<String, Channel> channels;
    private Environment environment;
    private AtomicLong lastIdleTimestamp;
    private volatile InternalProcessRuntime processRuntime;
    private transient KieRuntimeFactory runtimeFactory;
    private AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private DroolsManagementAgent.CBSKey mbeanRegisteredCBSKey;
    private boolean stateless;
    private List<AsyncReceiveNode.AsyncReceiveMemory> receiveNodeMemories;
    private transient StatefulSessionPool pool;
    private transient boolean alive = true;
    private final AtomicInteger opCounter = new AtomicInteger(0);
    private EntryPointsManager entryPointsManager;
    private EndOperationListener endOperationListener;
    public static final DummyInternalProcessRuntime DUMMY_PROCESS_RUNTIME = new DummyInternalProcessRuntime();

    public StatefulKnowledgeSessionImpl() {
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase) {
        this(id, kBase, true, kBase.getSessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, boolean initInitFactHandle, SessionConfiguration config, Environment environment) {
        this(id, kBase, kBase != null ? kBase.newFactHandleFactory() : null, initInitFactHandle, 1L, config, environment, new RuleRuntimeEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), null);
    }

    public StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, long propagationContext, SessionConfiguration config, InternalAgenda agenda, Environment environment) {
        this(id, kBase, handleFactory, false, propagationContext, config, environment, new RuleRuntimeEventSupport(), new AgendaEventSupport(), new RuleEventListenerSupport(), agenda);
    }

    private StatefulKnowledgeSessionImpl(long id, InternalKnowledgeBase kBase, FactHandleFactory handleFactory, boolean initInitFactHandle, long propagationContext, SessionConfiguration config, Environment environment, RuleRuntimeEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport, RuleEventListenerSupport ruleEventListenerSupport, InternalAgenda agenda) {
        this.id = id;
        this.handleFactory = handleFactory;
        this.ruleRuntimeEventSupport = workingMemoryEventSupport;
        this.agendaEventSupport = agendaEventSupport;
        this.ruleEventListenerSupport = ruleEventListenerSupport;
        this.propagationIdCounter = new AtomicLong(propagationContext);
        this.init(config, environment, propagationContext);
        this.kBase = kBase;
        this.entryPointsManager = new EntryPointsManager((ReteEvaluator)this);
        this.nodeMemories = new ConcurrentNodeMemories((RuleBase)kBase);
        this.registerReceiveNodes(kBase.getReceiveNodes());
        RuleBaseConfiguration conf = kBase.getConfiguration();
        this.pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        this.agenda = agenda != null ? agenda : RuntimeComponentFactory.get().getAgendaFactory().createAgenda((RuleBase)kBase);
        this.agenda.setWorkingMemory((InternalWorkingMemory)this);
        this.sequential = conf.isSequential();
        if (initInitFactHandle) {
            this.initialFactHandle = this.initInitialFact(kBase, null);
        }
    }

    public StatefulKnowledgeSessionImpl setStateless(boolean stateless) {
        this.stateless = stateless;
        return this;
    }

    public void init(SessionConfiguration config, Environment environment) {
        this.init(config, environment, 1L);
    }

    private void init(SessionConfiguration config, Environment environment, long propagationContext) {
        this.config = config;
        this.environment = environment;
        this.propagationIdCounter = new AtomicLong(propagationContext);
        Globals globals = (Globals)this.environment.get("org.kie.Globals");
        this.globalResolver = globals != null ? (!(globals instanceof GlobalResolver) ? new GlobalsAdapter(globals) : (GlobalResolver)globals) : new MapGlobalResolver();
        this.kieBaseEventListeners = new ArrayList<KieBaseEventListener>();
        this.lock = new ReentrantLock();
        this.timerService = this.createTimerService();
        this.lastIdleTimestamp = new AtomicLong(-1L);
    }

    protected TimerService createTimerService() {
        return TimerServiceFactory.getTimerService((SessionConfiguration)this.config);
    }

    private void registerReceiveNodes(List<AsyncReceiveNode> nodes) {
        this.receiveNodeMemories = nodes == null ? Collections.emptyList() : nodes.stream().map(this::getNodeMemory).collect(Collectors.toList());
    }

    public void initMBeans(String containerId, String kbaseName, String ksessionName) {
        if (this.kBase.getConfiguration() != null && this.kBase.getConfiguration().isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            this.mbeanRegisteredCBSKey = new DroolsManagementAgent.CBSKey(containerId, kbaseName, ksessionName);
            DroolsManagementAgent.getInstance().registerKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, (KieRuntimeEventManager)this);
        }
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.entryPointsManager.getDefaultEntryPoint().getTruthMaintenanceSystem();
    }

    public FactHandleFactory getHandleFactory() {
        return this.handleFactory;
    }

    public void setHandleFactory(FactHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
    }

    public <T> T getKieRuntime(Class<T> cls) {
        return this.createRuntimeService(cls);
    }

    public synchronized <T> T createRuntimeService(Class<T> cls) {
        if (this.runtimeFactory == null) {
            this.runtimeFactory = KieRuntimeFactory.of((KieBase)this.getKieBase());
        }
        return (T)this.runtimeFactory.get(cls);
    }

    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPointsManager.getEntryPoint(name);
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.entryPointsManager.getEntryPoints();
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.ruleRuntimeEventSupport.getEventListeners();
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    private InternalProcessRuntime createProcessRuntime() {
        InternalProcessRuntime processRuntime = ProcessRuntimeFactory.newProcessRuntime(this);
        if (processRuntime == null) {
            processRuntime = DUMMY_PROCESS_RUNTIME;
        }
        return processRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalProcessRuntime getProcessRuntime() {
        if (this.processRuntime == null) {
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = this;
            synchronized (statefulKnowledgeSessionImpl) {
                if (this.processRuntime == null) {
                    this.processRuntime = this.createProcessRuntime();
                }
            }
        }
        return this.processRuntime;
    }

    public InternalProcessRuntime internalGetProcessRuntime() {
        return this.processRuntime;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.getProcessRuntime().addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.getProcessRuntime().getProcessEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.getProcessRuntime().removeEventListener(listener);
    }

    public KieBase getKieBase() {
        return this.kBase;
    }

    StatefulKnowledgeSessionImpl fromPool(StatefulSessionPool pool) {
        this.pool = pool;
        this.alive = true;
        return this;
    }

    public void dispose() {
        this.alive = false;
        if (this.pool != null) {
            this.pool.release(this);
            return;
        }
        if (!this.agenda.dispose((InternalWorkingMemory)this)) {
            return;
        }
        if (this.logger != null) {
            try {
                this.logger.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            ep.dispose();
        }
        for (AsyncReceiveNode.AsyncReceiveMemory receiveMemory : this.receiveNodeMemories) {
            receiveMemory.dispose();
        }
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.agendaEventSupport.clear();
        for (KieBaseEventListener listener : this.kieBaseEventListeners) {
            this.kBase.removeEventListener(listener);
        }
        if (this.processRuntime != null) {
            this.processRuntime.dispose();
        }
        this.timerService.shutdown();
        if (this.workItemManager != null) {
            ((org.drools.core.process.instance.WorkItemManager)this.workItemManager).dispose();
        }
        this.kBase.disposeStatefulSession((InternalWorkingMemory)this);
        if (this.mbeanRegistered.get()) {
            DroolsManagementAgent.getInstance().unregisterKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, (KieRuntimeEventManager)this);
        }
    }

    public boolean isAlive() {
        return this.alive && this.agenda.isAlive();
    }

    public void destroy() {
        this.dispose();
    }

    public void update(FactHandle factHandle) {
        this.update(factHandle, ((InternalFactHandle)factHandle).getObject());
    }

    public void abortProcessInstance(long id) {
        this.getProcessRuntime().abortProcessInstance(id);
    }

    public void signalEvent(String type, Object event) {
        this.getProcessRuntime().signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.getProcessRuntime().signalEvent(type, event, processInstanceId);
    }

    public Globals getGlobals() {
        return (Globals)this.getGlobalResolver();
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return new ObjectStoreWrapper(this.getObjectStore(), null, 1);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.getObjectStore(), filter, 1);
    }

    public Collection<?> getObjects() {
        return new ObjectStoreWrapper(this.getObjectStore(), null, 0);
    }

    public Collection<?> getObjects(ObjectFilter filter) {
        return new ObjectStoreWrapper(this.getObjectStore(), filter, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        ExecutableRunner runner = ExecutableRunner.create();
        RequestContext context = ((RequestContext)runner.createContext()).with((KieBase)this.kBase).with((KieSession)this);
        if (!(command instanceof BatchExecutionCommand)) {
            return (T)runner.execute(command, (Context)context);
        }
        try {
            this.startBatchExecution();
            Object object = runner.execute(command, (Context)context);
            return (T)object;
        }
        finally {
            this.endBatchExecution();
            if (this.kBase.flushModifications() && !this.stateless) {
                this.fireAllRules();
            }
        }
    }

    public InternalFactHandle initInitialFact(InternalKnowledgeBase kBase, MarshallerReaderContext context) {
        InternalWorkingMemoryEntryPoint defaultEntryPoint = this.entryPointsManager.getDefaultEntryPoint();
        InternalFactHandle handle = this.getFactHandleFactory().newInitialFactHandle((WorkingMemoryEntryPoint)defaultEntryPoint);
        ObjectTypeNode otn = (ObjectTypeNode)defaultEntryPoint.getEntryPointNode().getObjectTypeNodes().get(ClassObjectType.InitialFact_ObjectType);
        if (otn != null) {
            PropagationContextFactory ctxFact = RuntimeComponentFactory.get().getPropagationContextFactory();
            PropagationContext pctx = ctxFact.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, handle, defaultEntryPoint.getEntryPoint(), context);
            otn.assertInitialFact(handle, pctx, (ReteEvaluator)this);
        }
        return handle;
    }

    public String getEntryPointId() {
        return EntryPointId.DEFAULT.getEntryPointId();
    }

    public QueryResultsImpl getQueryResultsFromRHS(String queryName, Object ... arguments) {
        return this.internalGetQueryResult(true, queryName, arguments);
    }

    public QueryResultsImpl getQueryResults(String queryName, Object ... arguments) {
        return this.internalGetQueryResult(false, queryName, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResultsImpl internalGetQueryResult(boolean calledFromRHS, String queryName, Object ... arguments) {
        try {
            if (!calledFromRHS) {
                this.startOperation();
                this.lock.lock();
            }
            this.kBase.executeQueuedActions();
            if (calledFromRHS) {
                this.flushPropagations();
                this.flushPropagations();
            } else {
                this.agenda.executeFlush();
                this.agenda.executeFlush();
            }
            DroolsQuery queryObject = new DroolsQuery(queryName, arguments, this.getQueryListenerInstance(), false);
            InternalFactHandle handle = this.handleFactory.newFactHandle((Object)queryObject, null, (ReteEvaluator)this, (WorkingMemoryEntryPoint)this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getEntryPoint());
            QueryResultsImpl tnodes = this.evalQuery(queryName, queryObject, handle, pCtx, calledFromRHS);
            ArrayList<Map> decls = new ArrayList<Map>();
            if (tnodes != null) {
                for (QueryTerminalNode node : tnodes) {
                    decls.add(node.getSubRule().getOuterDeclarations());
                }
            }
            this.handleFactory.destroyFactHandle(handle);
            QueryResultsImpl queryResultsImpl = new QueryResultsImpl(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), (ReteEvaluator)this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
            return queryResultsImpl;
        }
        finally {
            if (!calledFromRHS) {
                this.lock.unlock();
                this.endOperation();
            }
        }
    }

    private InternalViewChangedEventListener getQueryListenerInstance() {
        switch (this.config.getQueryListenerOption()) {
            case STANDARD: {
                return new StandardQueryViewChangedEventListener();
            }
            case LIGHTWEIGHT: {
                return new NonCloningQueryViewListener();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        try {
            this.startOperation();
            this.lock.lock();
            this.kBase.executeQueuedActions();
            this.agenda.executeFlush();
            DroolsQuery queryObject = new DroolsQuery(query, arguments, (InternalViewChangedEventListener)new OpenQueryViewChangedEventListenerAdapter(listener), true);
            InternalFactHandle handle = this.handleFactory.newFactHandle((Object)queryObject, null, (ReteEvaluator)this, (WorkingMemoryEntryPoint)this);
            PropagationContext pCtx = this.pctxFactory.createPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getEntryPoint());
            this.evalQuery(queryObject.getName(), queryObject, handle, pCtx, false);
            LiveQueryImpl liveQueryImpl = new LiveQueryImpl((InternalWorkingMemory)this, (FactHandle)handle);
            return liveQueryImpl;
        }
        finally {
            this.lock.unlock();
            this.endOperation();
        }
    }

    private QueryTerminalNode[] evalQuery(String queryName, DroolsQuery queryObject, InternalFactHandle handle, PropagationContext pCtx, boolean isCalledFromRHS) {
        PropagationEntry.ExecuteQuery executeQuery = new PropagationEntry.ExecuteQuery(queryName, queryObject, handle, pCtx, isCalledFromRHS);
        this.addPropagation((PropagationEntry)executeQuery);
        return (QueryTerminalNode[])executeQuery.getResult();
    }

    public void closeLiveQuery(InternalFactHandle factHandle) {
        try {
            this.startOperation();
            this.lock.lock();
            ExecuteCloseLiveQuery query = new ExecuteCloseLiveQuery(factHandle);
            this.addPropagation((PropagationEntry)query);
            query.getResult();
        }
        finally {
            this.lock.unlock();
            this.endOperation();
        }
    }

    public EntryPointId getEntryPoint() {
        return this.entryPointsManager.getDefaultEntryPoint().getEntryPoint();
    }

    public ReteEvaluator getReteEvaluator() {
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)this.getKnowledgeRuntime();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)ksession.getKieBase(), (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)stream, (KieSession)((StatefulKnowledgeSession)this.getKnowledgeRuntime()));
        stream.close();
        byte[] bytes = stream.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
    }

    public void updateEntryPointsCache() {
        this.entryPointsManager.updateEntryPointsCache();
    }

    public SessionConfiguration getSessionConfiguration() {
        return this.config;
    }

    public void reset() {
        if (this.nodeMemories != null) {
            this.nodeMemories.resetAllMemories((StatefulKnowledgeSession)this);
        }
        this.agenda.reset();
        this.globalResolver.clear();
        this.kieBaseEventListeners.clear();
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.agendaEventSupport.clear();
        this.handleFactory.clear(0L, 0L);
        this.propagationIdCounter.set(0L);
        this.lastIdleTimestamp.set(-1L);
        this.entryPointsManager.reset();
        this.timerService.reset();
        if (this.processRuntime != null) {
            this.processRuntime.dispose();
            this.processRuntime = null;
        }
        this.initialFactHandle = this.initInitialFact(this.kBase, null);
    }

    public void reset(long handleId, long handleCounter, long propagationCounter) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clear();
        }
        this.agenda.clear();
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            ep.reset();
        }
        this.handleFactory.clear(handleId, handleCounter);
        this.propagationIdCounter = new AtomicLong(propagationCounter);
        this.lastIdleTimestamp.set(-1L);
    }

    public void setRuleRuntimeEventSupport(RuleRuntimeEventSupport ruleRuntimeEventSupport) {
        this.ruleRuntimeEventSupport = ruleRuntimeEventSupport;
    }

    public void setAgendaEventSupport(AgendaEventSupport agendaEventSupport) {
        this.agendaEventSupport = agendaEventSupport;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
        this.ruleRuntimeEventSupport.addEventListener((EventListener)listener);
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.ruleRuntimeEventSupport.removeEventListener((EventListener)listener);
    }

    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener((EventListener)listener);
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener((EventListener)listener);
    }

    public void addEventListener(KieBaseEventListener listener) {
        this.kBase.addEventListener(listener);
        this.kieBaseEventListeners.add(listener);
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return Collections.unmodifiableCollection(this.kieBaseEventListeners);
    }

    public void removeEventListener(KieBaseEventListener listener) {
        this.kBase.removeEventListener(listener);
        this.kieBaseEventListeners.remove(listener);
    }

    public RuleEventListenerSupport getRuleEventSupport() {
        return this.ruleEventListenerSupport;
    }

    public void setRuleEventListenerSupport(RuleEventListenerSupport ruleEventListenerSupport) {
        this.ruleEventListenerSupport = ruleEventListenerSupport;
    }

    public void addEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.addEventListener((EventListener)listener);
    }

    public void removeEventListener(RuleEventListener listener) {
        this.ruleEventListenerSupport.removeEventListener((EventListener)listener);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(String identifier, Object value) {
        if (value == null) {
            return;
        }
        try {
            this.kBase.readLock();
            this.startOperation();
            Class type = (Class)this.kBase.getGlobals().get(identifier);
            if (type == null) {
                throw new RuntimeException("Unexpected global [" + identifier + "]");
            }
            if (!type.isInstance(value)) {
                throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], found [" + value.getClass().getName() + "].");
            }
            this.globalResolver.setGlobal(identifier, value);
        }
        finally {
            this.endOperation();
            this.kBase.readUnlock();
        }
    }

    public void removeGlobal(String identifier) {
        this.globalResolver.removeGlobal(identifier);
    }

    public void setGlobalResolver(GlobalResolver globalResolver) {
        try {
            this.lock.lock();
            this.globalResolver = globalResolver;
        }
        finally {
            this.lock.unlock();
        }
    }

    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    public Calendars getCalendars() {
        if (this.calendars == null) {
            this.calendars = new CalendarsImpl();
        }
        return this.calendars;
    }

    public int getId() {
        this.checkAlive();
        return this.id.intValue();
    }

    public long getIdentifier() {
        this.checkAlive();
        return this.id;
    }

    public void setIdentifier(long id) {
        this.checkAlive();
        this.id = id;
    }

    protected void checkAlive() {
        if (!this.isAlive()) {
            throw new IllegalStateException(ERRORMSG);
        }
    }

    public Object getGlobal(String identifier) {
        return this.globalResolver.resolveGlobal(identifier);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public InternalAgenda getAgenda() {
        return this.agenda;
    }

    public void clearAgenda() {
        this.agenda.clearAndCancel();
    }

    public void clearAgendaGroup(String group) {
        this.agenda.clearAndCancelAgendaGroup(group);
    }

    public void clearActivationGroup(String group) {
        this.agenda.clearAndCancelActivationGroup(group);
    }

    public void clearRuleFlowGroup(String group) {
        this.agenda.clearAndCancelRuleFlowGroup(group);
    }

    public ActivationsManager getActivationsManager() {
        return this.agenda;
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    public void halt() {
        this.agenda.halt();
    }

    public int fireAllRules() {
        return this.fireAllRules(null, -1);
    }

    public int fireAllRules(int fireLimit) {
        return this.fireAllRules(null, fireLimit);
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.checkAlive();
        try {
            this.startOperation();
            int n = this.internalFireAllRules(agendaFilter, fireLimit);
            return n;
        }
        finally {
            this.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalFireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        int fireCount = 0;
        try {
            fireCount = this.agenda.fireAllRules(agendaFilter, fireLimit);
        }
        finally {
            if (this.kBase.flushModifications() && !this.stateless) {
                fireCount += this.internalFireAllRules(agendaFilter, fireLimit);
            }
        }
        return fireCount;
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (this.isSequential()) {
            throw new IllegalStateException("fireUntilHalt() can not be called in sequential mode.");
        }
        try {
            this.startOperation();
            this.agenda.fireUntilHalt(agendaFilter);
        }
        finally {
            this.endOperation();
        }
    }

    public Object getObject(FactHandle handle) {
        if (((InternalFactHandle)handle).isDisconnected()) {
            handle = this.entryPointsManager.getDefaultEntryPoint().getObjectStore().reconnect((InternalFactHandle)handle);
        }
        return this.entryPointsManager.getDefaultEntryPoint().getObject(handle);
    }

    public ObjectStore getObjectStore() {
        return this.entryPointsManager.getDefaultEntryPoint().getObjectStore();
    }

    public InternalFactHandle getFactHandle(Object object) {
        return (InternalFactHandle)this.entryPointsManager.getDefaultEntryPoint().getFactHandle(object);
    }

    public Iterator iterateObjects() {
        return this.getObjectStore().iterateObjects();
    }

    public Iterator iterateObjects(ObjectFilter filter) {
        return this.getObjectStore().iterateObjects(filter);
    }

    public Iterator<InternalFactHandle> iterateFactHandles() {
        return this.getObjectStore().iterateFactHandles();
    }

    public Iterator<InternalFactHandle> iterateFactHandles(ObjectFilter filter) {
        return this.getObjectStore().iterateFactHandles(filter);
    }

    public void setFocus(String focus) {
        this.agenda.getAgendaGroup(focus).setFocus();
    }

    public FactHandle insertAsync(Object object) {
        this.checkAlive();
        return this.entryPointsManager.getDefaultEntryPoint().insertAsync(object);
    }

    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    public FactHandle insert(Object object, boolean dynamic) {
        return this.insert(object, dynamic, null, null);
    }

    public void submit(final KieSession.AtomicAction action) {
        this.agenda.addPropagation((PropagationEntry)new PropagationEntry.AbstractPropagationEntry(){

            public void execute(ReteEvaluator reteEvaluator) {
                action.execute((KieSession)reteEvaluator);
            }
        });
    }

    public void updateTraits(InternalFactHandle h, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.entryPointsManager.getDefaultEntryPoint().getTraitHelper().updateTraits(h, mask, modifiedClass, activation);
    }

    public <T, K, X extends TraitableBean> Thing<K> shed(Activation activation, TraitableBean<K, X> core, Class<T> trait) {
        return this.entryPointsManager.getDefaultEntryPoint().getTraitHelper().shed(core, trait, activation);
    }

    public <T, K> T don(Activation activation, K core, Collection<Class<? extends Thing>> traits, boolean b, Mode[] modes) {
        return (T)this.entryPointsManager.getDefaultEntryPoint().getTraitHelper().don(activation, core, traits, b, modes);
    }

    public <T, K> T don(Activation activation, K core, Class<T> trait, boolean b, Mode[] modes) {
        return (T)this.entryPointsManager.getDefaultEntryPoint().getTraitHelper().don(activation, core, trait, b, modes);
    }

    public FactHandle insert(Object object, boolean dynamic, RuleImpl rule, TerminalNode terminalNode) {
        this.checkAlive();
        return this.entryPointsManager.getDefaultEntryPoint().insert(object, dynamic, rule, terminalNode);
    }

    public void retract(FactHandle handle) {
        this.delete(handle);
    }

    public void delete(FactHandle handle) {
        this.delete(handle, null, null);
    }

    public void delete(FactHandle handle, FactHandle.State fhState) {
        this.delete(handle, null, null, fhState);
    }

    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode) {
        this.delete(factHandle, rule, terminalNode, FactHandle.State.ALL);
    }

    public void delete(FactHandle factHandle, RuleImpl rule, TerminalNode terminalNode, FactHandle.State fhState) {
        this.checkAlive();
        this.entryPointsManager.getDefaultEntryPoint().delete(factHandle, rule, terminalNode, fhState);
    }

    public EntryPointNode getEntryPointNode() {
        return this.entryPointsManager.getDefaultEntryPoint().getEntryPointNode();
    }

    public void update(FactHandle handle, Object object) {
        this.update(handle, object, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
    }

    public void update(FactHandle handle, Object object, String ... modifiedProperties) {
        this.checkAlive();
        this.entryPointsManager.getDefaultEntryPoint().update(handle, object, modifiedProperties);
    }

    public void update(FactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.checkAlive();
        this.entryPointsManager.getDefaultEntryPoint().update(factHandle, object, mask, modifiedClass, activation);
    }

    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node) {
        return (T)this.nodeMemories.getNodeMemory(node, (ReteEvaluator)this);
    }

    public void clearNodeMemory(MemoryFactory node) {
        if (this.nodeMemories != null) {
            this.nodeMemories.clearNodeMemory(node);
        }
    }

    public NodeMemories getNodeMemories() {
        return this.nodeMemories;
    }

    public RuleRuntimeEventSupport getRuleRuntimeEventSupport() {
        return this.ruleRuntimeEventSupport;
    }

    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
    }

    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public Lock getLock() {
        return this.lock;
    }

    public ProcessInstance startProcess(String processId) {
        return this.getProcessRuntime().startProcess(processId);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.getProcessRuntime().startProcess(processId, parameters);
    }

    public ProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
        return this.getProcessRuntime().startProcess(processId, agendaFilter);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
        return this.getProcessRuntime().startProcess(processId, parameters, agendaFilter);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.getProcessRuntime().createProcessInstance(processId, parameters);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.getProcessRuntime().startProcessInstance(processInstanceId);
    }

    public Collection<ProcessInstance> getProcessInstances() {
        return this.getProcessRuntime().getProcessInstances();
    }

    public ProcessInstance getProcessInstance(Object processInstanceId) {
        return this.getProcessInstance((Long)processInstanceId);
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.getProcessRuntime().getProcessInstance(processInstanceId);
    }

    public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.getProcessRuntime().startProcess(processId, correlationKey, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.getProcessRuntime().createProcessInstance(processId, correlationKey, parameters);
    }

    public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.getProcessRuntime().getProcessInstance(correlationKey);
    }

    public ProcessInstance getProcessInstance(long processInstanceId, boolean readOnly) {
        return this.getProcessRuntime().getProcessInstance(processInstanceId, readOnly);
    }

    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = this.config.getWorkItemManagerFactory().createWorkItemManager(this.getKnowledgeRuntime());
            HashMap<String, InternalKnowledgeRuntime> params = new HashMap<String, InternalKnowledgeRuntime>();
            params.put("ksession", this.getKnowledgeRuntime());
            Map workItemHandlers = this.config.getWorkItemHandlers(params);
            if (workItemHandlers != null) {
                for (Map.Entry entry : workItemHandlers.entrySet()) {
                    this.workItemManager.registerWorkItemHandler((String)entry.getKey(), (WorkItemHandler)entry.getValue());
                }
            }
        }
        return this.workItemManager;
    }

    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.entryPointsManager.getDefaultEntryPoint().getObjectTypeConfigurationRegistry();
    }

    public InternalFactHandle getInitialFactHandle() {
        return this.initialFactHandle;
    }

    public void setInitialFactHandle(InternalFactHandle initialFactHandle) {
        this.initialFactHandle = initialFactHandle;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    public void startBatchExecution() {
        this.lock.lock();
    }

    public void endBatchExecution() {
        this.lock.unlock();
    }

    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this;
    }

    public void registerChannel(String name, Channel channel) {
        this.getChannels().put(name, channel);
    }

    public void unregisterChannel(String name) {
        if (this.channels != null) {
            this.channels.remove(name);
        }
    }

    public Map<String, Channel> getChannels() {
        if (this.channels == null) {
            this.channels = new ConcurrentHashMap<String, Channel>();
        }
        return this.channels;
    }

    public long getFactCount() {
        return this.getObjectStore().size();
    }

    public long getTotalFactCount() {
        long result = 0L;
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            result += ep.getFactCount();
        }
        return result;
    }

    public void startOperation() {
        if (this.getSessionConfiguration().isThreadSafe() && this.opCounter.getAndIncrement() == 0) {
            this.lastIdleTimestamp.set(-1L);
        }
    }

    public void setEndOperationListener(EndOperationListener listener) {
        this.endOperationListener = listener;
    }

    public void endOperation() {
        if (this.getSessionConfiguration().isThreadSafe() && this.opCounter.decrementAndGet() == 0) {
            this.lastIdleTimestamp.set(this.timerService.getCurrentTime());
            if (this.endOperationListener != null) {
                this.endOperationListener.endOperation(this.getKnowledgeRuntime());
            }
        }
    }

    public long getIdleTime() {
        long lastIdle = this.lastIdleTimestamp.get();
        return lastIdle > -1L ? this.timerService.getCurrentTime() - lastIdle : -1L;
    }

    public long getLastIdleTimestamp() {
        return this.lastIdleTimestamp.get();
    }

    public void prepareToFireActivation() {
    }

    public void activationFired() {
    }

    public long getTimeToNextJob() {
        return this.timerService.getTimeToNextJob();
    }

    public void addPropagation(PropagationEntry propagationEntry, boolean register) {
        try {
            if (register) {
                this.startOperation();
            }
            this.agenda.addPropagation(propagationEntry);
        }
        finally {
            if (register) {
                this.endOperation();
            }
        }
    }

    public void flushPropagations() {
        this.agenda.flushPropagations();
    }

    public void notifyWaitOnRest() {
        this.agenda.notifyWaitOnRest();
    }

    public Iterator<? extends PropagationEntry> getActionsIterator() {
        return this.agenda.getActionsIterator();
    }

    public void activate() {
        this.agenda.activate();
    }

    public void deactivate() {
        this.agenda.deactivate();
    }

    public boolean tryDeactivate() {
        return this.agenda.tryDeactivate();
    }

    public void cancelActivation(Activation activation, boolean declarativeAgenda) {
        if (declarativeAgenda && activation.getActivationFactHandle() != null) {
            this.getEntryPointNode().retractActivation(activation.getActivationFactHandle(), activation.getPropagationContext(), (ReteEvaluator)this);
        }
    }

    public String toString() {
        return "KieSession[" + this.id + "]";
    }

    public ProcessInstance startProcessFromNodeIds(String processId, Map<String, Object> params, String ... nodeInstancesIds) {
        return this.getProcessRuntime().startProcessFromNodeIds(processId, params, nodeInstancesIds);
    }

    public ProcessInstance startProcessFromNodeIds(String processId, CorrelationKey key, Map<String, Object> params, String ... nodeIds) {
        return this.getProcessRuntime().startProcessFromNodeIds(processId, key, params, nodeIds);
    }

    public static class DummyInternalProcessRuntime
    implements InternalProcessRuntime {
        public void dispose() {
        }

        public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
            throw new UnsupportedOperationException();
        }

        public void clearProcessInstances() {
        }

        public void clearProcessInstancesState() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
            throw new UnsupportedOperationException();
        }

        public void addEventListener(ProcessEventListener listener) {
        }

        public void removeEventListener(ProcessEventListener listener) {
        }

        public Collection<ProcessEventListener> getProcessEventListeners() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public void signalEvent(String type, Object event) {
            throw new UnsupportedOperationException();
        }

        public void signalEvent(String type, Object event, long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public Collection<ProcessInstance> getProcessInstances() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance getProcessInstance(long processInstanceId, boolean readonly) {
            throw new UnsupportedOperationException();
        }

        public void abortProcessInstance(long processInstanceId) {
            throw new UnsupportedOperationException();
        }

        public WorkItemManager getWorkItemManager() {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcessFromNodeIds(String processId, Map<String, Object> params, String ... nodeInstancesIds) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance startProcessFromNodeIds(String processId, CorrelationKey key, Map<String, Object> params, String ... nodeIds) {
            throw new UnsupportedOperationException();
        }
    }

    public static class GlobalsAdapter
    implements GlobalResolver {
        private Globals globals;

        public GlobalsAdapter(Globals globals) {
            this.globals = globals;
        }

        public Object resolveGlobal(String identifier) {
            return this.globals.get(identifier);
        }

        public void setGlobal(String identifier, Object value) {
            this.globals.set(identifier, value);
        }

        public void removeGlobal(String identifier) {
            ((GlobalResolver)this.globals).removeGlobal(identifier);
        }

        public void clear() {
            if (this.globals instanceof GlobalResolver) {
                ((GlobalResolver)this.globals).clear();
            }
        }
    }

    private class ExecuteCloseLiveQuery
    extends PropagationEntry.PropagationEntryWithResult<Void> {
        private final InternalFactHandle factHandle;

        private ExecuteCloseLiveQuery(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void execute(ReteEvaluator reteEvaluator) {
            LeftInputAdapterNode lian = (LeftInputAdapterNode)this.factHandle.getFirstLeftTuple().getTupleSource();
            LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)StatefulKnowledgeSessionImpl.this.getNodeMemory(lian);
            SegmentMemory lsmem = lmem.getSegmentMemory();
            LeftTuple childLeftTuple = this.factHandle.getFirstLeftTuple();
            LeftInputAdapterNode.doDeleteObject((LeftTuple)childLeftTuple, (PropagationContext)childLeftTuple.getPropagationContext(), (SegmentMemory)lsmem, (ReteEvaluator)StatefulKnowledgeSessionImpl.this, (LeftInputAdapterNode)lian, (boolean)false, (LeftInputAdapterNode.LiaNodeMemory)lmem);
            for (PathMemory rm : lmem.getSegmentMemory().getPathMemories()) {
                RuleAgendaItem evaluator = StatefulKnowledgeSessionImpl.this.agenda.createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)rm.getPathEndNode());
                evaluator.getRuleExecutor().setDirty(true);
                evaluator.getRuleExecutor().evaluateNetworkAndFire((ReteEvaluator)StatefulKnowledgeSessionImpl.this, null, 0, -1);
            }
            StatefulKnowledgeSessionImpl.this.getFactHandleFactory().destroyFactHandle(this.factHandle);
            this.done(null);
        }
    }
}

