/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.ValueType;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class ClassFieldReader
implements Externalizable,
InternalReadAccessor {
    private static final long serialVersionUID = 510L;
    private String className;
    private String fieldName;
    private transient InternalReadAccessor reader;

    public static String decapitalizeFieldName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public ClassFieldReader() {
    }

    public ClassFieldReader(String className, String fieldName) {
        this.className = className;
        this.fieldName = ClassFieldReader.decapitalizeFieldName(fieldName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.fieldName);
    }

    @Override
    public void readExternal(ObjectInput is) throws ClassNotFoundException, IOException {
        this.className = (String)is.readObject();
        this.fieldName = (String)is.readObject();
    }

    public void setReadAccessor(InternalReadAccessor reader) {
        this.reader = reader;
    }

    @Override
    public int getIndex() {
        return this.reader.getIndex();
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean hasReadAccessor() {
        return this.reader != null;
    }

    @Override
    public Object getValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getValue(reteEvaluator, object);
    }

    @Override
    public ValueType getValueType() {
        return this.reader.getValueType();
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.reader != null ? this.reader.getExtractToClass() : null;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.reader.getExtractToClass());
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.className + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassFieldReader)) {
            return false;
        }
        ClassFieldReader other = (ClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    @Override
    public boolean getBooleanValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getBooleanValue(reteEvaluator, object);
    }

    @Override
    public byte getByteValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getByteValue(reteEvaluator, object);
    }

    @Override
    public char getCharValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getCharValue(reteEvaluator, object);
    }

    @Override
    public double getDoubleValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getDoubleValue(reteEvaluator, object);
    }

    @Override
    public float getFloatValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getFloatValue(reteEvaluator, object);
    }

    @Override
    public int getIntValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getIntValue(reteEvaluator, object);
    }

    @Override
    public long getLongValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getLongValue(reteEvaluator, object);
    }

    @Override
    public short getShortValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getShortValue(reteEvaluator, object);
    }

    @Override
    public boolean isNullValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.isNullValue(reteEvaluator, object);
    }

    @Override
    public Method getNativeReadMethod() {
        return this.reader.getNativeReadMethod();
    }

    @Override
    public String getNativeReadMethodName() {
        return this.reader.getNativeReadMethod().getName();
    }

    @Override
    public int getHashCode(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getHashCode(reteEvaluator, object);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return "this".equals(this.fieldName);
    }

    @Override
    public boolean getBooleanValue(Object object) {
        return this.reader.getBooleanValue(object);
    }

    @Override
    public byte getByteValue(Object object) {
        return this.reader.getByteValue(object);
    }

    @Override
    public char getCharValue(Object object) {
        return this.reader.getCharValue(object);
    }

    @Override
    public double getDoubleValue(Object object) {
        return this.reader.getDoubleValue(object);
    }

    @Override
    public float getFloatValue(Object object) {
        return this.reader.getFloatValue(object);
    }

    @Override
    public int getHashCode(Object object) {
        return this.reader.getHashCode(object);
    }

    @Override
    public int getIntValue(Object object) {
        return this.reader.getIntValue(object);
    }

    @Override
    public long getLongValue(Object object) {
        return this.reader.getLongValue(object);
    }

    @Override
    public short getShortValue(Object object) {
        return this.reader.getShortValue(object);
    }

    @Override
    public Object getValue(Object object) {
        return this.reader.getValue(object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.reader.isNullValue(object);
    }

    @Override
    public BigDecimal getBigDecimalValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getBigDecimalValue(reteEvaluator, object);
    }

    @Override
    public BigInteger getBigIntegerValue(ReteEvaluator reteEvaluator, Object object) {
        return this.reader.getBigIntegerValue(reteEvaluator, object);
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        return this.reader.getBigDecimalValue(object);
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        return this.reader.getBigIntegerValue(object);
    }

    public AccessorKey getAccessorKey() {
        return new AccessorKey(this.className, this.fieldName, AccessorKey.AccessorType.FieldAccessor);
    }
}

