/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceTypeImpl;
import org.kie.memorycompiler.resources.KiePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieFileSystemImpl
implements KieFileSystem,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(KieFileSystemImpl.class);
    private final MemoryFileSystem mfs;

    public KieFileSystemImpl() {
        this(new MemoryFileSystem());
    }

    public KieFileSystemImpl(MemoryFileSystem mfs) {
        this.mfs = mfs;
    }

    public KieFileSystem write(String path, byte[] content) {
        this.mfs.write(path, content, true);
        return this;
    }

    public KieFileSystem write(KiePath path, byte[] content) {
        this.mfs.write(path, content, true);
        return this;
    }

    public KieFileSystem write(String path, String text) {
        return this.write(path, text.getBytes(IoUtils.UTF8_CHARSET));
    }

    public KieFileSystem write(KiePath path, String text) {
        return this.write(path, text.getBytes(IoUtils.UTF8_CHARSET));
    }

    public KieFileSystem write(String path, Resource resource) {
        this.mfs.write(KiePath.of((String)path), resource);
        return this;
    }

    public KieFileSystem write(KiePath path, Resource resource) {
        this.mfs.write(path, resource);
        return this;
    }

    public KieFileSystem write(Resource resource) {
        try {
            String target;
            String string = target = resource.getTargetPath() != null ? resource.getTargetPath() : resource.getSourcePath();
            if (target != null) {
                String path;
                String prefix = resource.getResourceType() == ResourceType.JAVA ? "src/main/java/" : "src/main/resources/";
                int prefixPos = target.indexOf(prefix);
                String string2 = path = prefixPos >= 0 ? target.substring(prefixPos) : prefix + target;
                if (resource.getResourceType() == ResourceType.XSD) {
                    this.write(path, ((InternalResource)resource).getBytes());
                } else {
                    this.write(path, resource);
                }
                ResourceConfiguration conf = resource.getConfiguration();
                if (conf != null) {
                    Properties prop = ResourceTypeImpl.toProperties((ResourceConfiguration)conf);
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    prop.store(buff, "Configuration properties for resource: " + target);
                    this.write(path + ".properties", buff.toByteArray());
                }
                return this;
            }
            throw new RuntimeException("Resource does not have neither a source nor a target path. Impossible to add it to the bundle. Please set either the source or target name of the resource before adding it." + resource.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to write Resource: " + resource.toString(), e);
        }
    }

    public void delete(String ... paths) {
        for (String path : paths) {
            this.mfs.remove(path);
        }
    }

    public byte[] read(String path) {
        return this.mfs.read(path);
    }

    public MemoryFileSystem asMemoryFileSystem() {
        return this.mfs;
    }

    public KieFileSystem generateAndWritePomXML(ReleaseId releaseId) {
        this.write("pom.xml", KieBuilderImpl.generatePomXml(releaseId));
        return this;
    }

    public KieFileSystem writePomXML(byte[] content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writePomXML(String content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writeKModuleXML(byte[] content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }

    public KieFileSystem writeKModuleXML(String content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }

    public MemoryFileSystem getMfs() {
        return this.mfs;
    }

    public KieFileSystem clone() {
        try {
            ByteArrayOutputStream byteArray = this.writeToByteArray(this);
            return this.readFromByteArray(byteArray);
        }
        catch (IOException | ClassNotFoundException ioe) {
            logger.warn("Unable to clone KieFileSystemImpl", (Throwable)ioe);
            return null;
        }
    }

    private KieFileSystem readFromByteArray(ByteArrayOutputStream byteArrayOutputStream) throws IOException, ClassNotFoundException {
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ObjectInputStream inputStream = new ObjectInputStream(byteArrayInputStream);
        return (KieFileSystem)inputStream.readObject();
    }

    private ByteArrayOutputStream writeToByteArray(KieFileSystemImpl obj) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        outputStream.writeObject(obj);
        outputStream.flush();
        outputStream.close();
        return byteArrayOutputStream;
    }
}

