/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.OperatorDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;

public class DumperContext {
    protected Map<String, OperatorDescr> aliases = new HashMap<String, OperatorDescr>();
    protected int counter = 0;
    protected List<BindingDescr> bindings = null;
    private RuleBuildContext ruleContext;
    private Map<String, String> inferredCasts;
    private int openCcd = 0;

    public void clear() {
        this.aliases.clear();
        this.counter = 0;
        this.bindings = null;
        this.openCcd = 0;
    }

    public void addInferredCast(String var, String cast) {
        if (this.inferredCasts == null) {
            this.inferredCasts = new HashMap<String, String>();
        }
        this.inferredCasts.put(var, cast);
    }

    public Map.Entry<String, String> getInferredCast(String expr) {
        if (this.inferredCasts != null) {
            for (Map.Entry<String, String> entry : this.inferredCasts.entrySet()) {
                if (!expr.matches(entry.getKey() + "\\s*\\..+")) continue;
                return entry;
            }
        }
        return null;
    }

    public Map<String, OperatorDescr> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, OperatorDescr> aliases) {
        this.aliases = aliases;
    }

    public String createAlias(OperatorDescr operator) {
        String alias = operator.getOperator() + this.counter++;
        operator.setAlias(alias);
        this.aliases.put(alias, operator);
        return alias;
    }

    public void addBinding(BindingDescr bind) {
        if (this.bindings == null) {
            this.bindings = new ArrayList<BindingDescr>();
        }
        this.bindings.add(bind);
    }

    public List<BindingDescr> getBindings() {
        return this.bindings == null ? Collections.EMPTY_LIST : this.bindings;
    }

    public RuleBuildContext getRuleContext() {
        return this.ruleContext;
    }

    public DumperContext setRuleContext(RuleBuildContext ruleContext) {
        this.ruleContext = ruleContext;
        return this;
    }

    public void incOpenCcd() {
        ++this.openCcd;
    }

    public void decOpenCcd() {
        --this.openCcd;
    }

    public boolean isCcdNested() {
        return this.openCcd > 0;
    }

    public boolean isInXpath() {
        return this.ruleContext != null && this.ruleContext.isInXpath();
    }

    public void setInXpath(boolean inXpath) {
        this.ruleContext.setInXpath(inXpath);
    }
}

