/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicForagerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.PooledEntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.QueuedValuePlacerConfig;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import org.optaplanner.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import org.optaplanner.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.decider.MultiThreadedConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForagerFactory;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacerFactory;
import org.optaplanner.core.impl.constructionheuristic.placer.PooledEntityPlacerFactory;
import org.optaplanner.core.impl.constructionheuristic.placer.QueuedEntityPlacerFactory;
import org.optaplanner.core.impl.constructionheuristic.placer.QueuedValuePlacerFactory;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.phase.AbstractPhaseFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class DefaultConstructionHeuristicPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, ConstructionHeuristicPhaseConfig> {
    public DefaultConstructionHeuristicPhaseFactory(ConstructionHeuristicPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public ConstructionHeuristicPhase<Solution_> buildPhase(int phaseIndex, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        EntityPlacerConfig entityPlacerConfig_;
        ConstructionHeuristicType constructionHeuristicType_ = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType(), ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE);
        EntitySorterManner entitySorterManner = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getEntitySorterManner(), constructionHeuristicType_.getDefaultEntitySorterManner());
        ValueSorterManner valueSorterManner = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getValueSorterManner(), constructionHeuristicType_.getDefaultValueSorterManner());
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.cloneBuilder().withReinitializeVariableFilterEnabled(true).withInitializedChainedValueFilterEnabled(true).withEntitySorterManner(entitySorterManner).withValueSorterManner(valueSorterManner).build();
        Termination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        if (((ConstructionHeuristicPhaseConfig)this.phaseConfig).getEntityPlacerConfig() == null) {
            entityPlacerConfig_ = this.buildUnfoldedEntityPlacerConfig(phaseConfigPolicy, constructionHeuristicType_);
        } else {
            entityPlacerConfig_ = ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getEntityPlacerConfig();
            if (((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType() != null) {
                throw new IllegalArgumentException("The constructionHeuristicType (" + ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType() + ") must not be configured if the entityPlacerConfig (" + entityPlacerConfig_ + ") is explicitly configured.");
            }
            if (((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList() != null) {
                throw new IllegalArgumentException("The moveSelectorConfigList (" + ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList() + ") cannot be configured if the entityPlacerConfig (" + entityPlacerConfig_ + ") is explicitly configured.");
            }
        }
        EntityPlacer entityPlacer = EntityPlacerFactory.create(entityPlacerConfig_).buildEntityPlacer(phaseConfigPolicy);
        DefaultConstructionHeuristicPhase.Builder<Solution_> builder = new DefaultConstructionHeuristicPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), phaseTermination, entityPlacer, this.buildDecider(phaseConfigPolicy, phaseTermination));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            builder.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            builder.setAssertExpectedStepScore(true);
            builder.setAssertShadowVariablesAreNotStaleAfterStep(true);
        }
        return builder.build();
    }

    private ConstructionHeuristicDecider<Solution_> buildDecider(HeuristicConfigPolicy<Solution_> configPolicy, Termination<Solution_> termination) {
        ConstructionHeuristicDecider<Solution_> decider;
        ConstructionHeuristicForagerConfig foragerConfig_ = Objects.requireNonNullElseGet(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getForagerConfig(), ConstructionHeuristicForagerConfig::new);
        ConstructionHeuristicForager forager = ConstructionHeuristicForagerFactory.create(foragerConfig_).buildForager(configPolicy);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        Integer moveThreadCount = configPolicy.getMoveThreadCount();
        if (moveThreadCount == null) {
            decider = new ConstructionHeuristicDecider<Solution_>(configPolicy.getLogIndentation(), termination, forager);
        } else {
            Integer moveThreadBufferSize = configPolicy.getMoveThreadBufferSize();
            if (moveThreadBufferSize == null) {
                moveThreadBufferSize = 10;
            }
            ThreadFactory threadFactory = configPolicy.buildThreadFactory(ChildThreadType.MOVE_THREAD);
            int selectedMoveBufferSize = moveThreadCount * moveThreadBufferSize;
            MultiThreadedConstructionHeuristicDecider<Solution_> multiThreadedDecider = new MultiThreadedConstructionHeuristicDecider<Solution_>(configPolicy.getLogIndentation(), termination, forager, threadFactory, moveThreadCount, selectedMoveBufferSize);
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                multiThreadedDecider.setAssertStepScoreFromScratch(true);
            }
            if (environmentMode.isIntrusiveFastAsserted()) {
                multiThreadedDecider.setAssertExpectedStepScore(true);
                multiThreadedDecider.setAssertShadowVariablesAreNotStaleAfterStep(true);
            }
            decider = multiThreadedDecider;
        }
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    private EntityPlacerConfig buildUnfoldedEntityPlacerConfig(HeuristicConfigPolicy<Solution_> phaseConfigPolicy, ConstructionHeuristicType constructionHeuristicType) {
        switch (constructionHeuristicType) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: 
            case WEAKEST_FIT: 
            case WEAKEST_FIT_DECREASING: 
            case STRONGEST_FIT: 
            case STRONGEST_FIT_DECREASING: 
            case ALLOCATE_ENTITY_FROM_QUEUE: {
                if (!ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList())) {
                    return QueuedEntityPlacerFactory.unfoldNew(phaseConfigPolicy, ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList());
                }
                return new QueuedEntityPlacerConfig();
            }
            case ALLOCATE_TO_VALUE_FROM_QUEUE: {
                if (!ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList())) {
                    return QueuedValuePlacerFactory.unfoldNew(this.checkSingleMoveSelectorConfig());
                }
                return new QueuedValuePlacerConfig();
            }
            case CHEAPEST_INSERTION: 
            case ALLOCATE_FROM_POOL: {
                if (!ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList())) {
                    return PooledEntityPlacerFactory.unfoldNew(phaseConfigPolicy, this.checkSingleMoveSelectorConfig());
                }
                return new PooledEntityPlacerConfig();
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + constructionHeuristicType + ") is not implemented.");
    }

    private MoveSelectorConfig<?> checkSingleMoveSelectorConfig() {
        if (((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList().size() != 1) {
            throw new IllegalArgumentException("For the constructionHeuristicType (" + ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType() + "), the moveSelectorConfigList (" + ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList() + ") must be a singleton. Use a single " + UnionMoveSelectorConfig.class.getSimpleName() + " or " + CartesianProductMoveSelectorConfig.class.getSimpleName() + " element to nest multiple MoveSelectors.");
        }
        return ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList().get(0);
    }
}

