/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.ExhaustiveSearchPhase;
import org.optaplanner.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultExhaustiveSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements ExhaustiveSearchPhase<Solution_> {
    protected final Comparator<ExhaustiveSearchNode> nodeComparator;
    protected final EntitySelector<Solution_> entitySelector;
    protected final ExhaustiveSearchDecider<Solution_> decider;
    protected final boolean assertWorkingSolutionScoreFromScratch;
    protected final boolean assertExpectedWorkingSolutionScore;

    private DefaultExhaustiveSearchPhase(Builder<Solution_> builder) {
        super(builder);
        this.nodeComparator = builder.nodeComparator;
        this.entitySelector = builder.entitySelector;
        this.decider = builder.decider;
        this.assertWorkingSolutionScoreFromScratch = builder.assertWorkingSolutionScoreFromScratch;
        this.assertExpectedWorkingSolutionScore = builder.assertExpectedWorkingSolutionScore;
    }

    @Override
    public String getPhaseTypeString() {
        return "Exhaustive Search";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        TreeSet<ExhaustiveSearchNode> expandableNodeQueue = new TreeSet<ExhaustiveSearchNode>(this.nodeComparator);
        ExhaustiveSearchPhaseScope<Solution_> phaseScope = new ExhaustiveSearchPhaseScope<Solution_>(solverScope);
        phaseScope.setExpandableNodeQueue(expandableNodeQueue);
        this.phaseStarted(phaseScope);
        while (!expandableNodeQueue.isEmpty() && !this.phaseTermination.isPhaseTerminated(phaseScope)) {
            ExhaustiveSearchStepScope<Solution_> stepScope = new ExhaustiveSearchStepScope<Solution_>(phaseScope);
            ExhaustiveSearchNode node = (ExhaustiveSearchNode)expandableNodeQueue.last();
            expandableNodeQueue.remove(node);
            stepScope.setExpandingNode(node);
            this.stepStarted(stepScope);
            this.restoreWorkingSolution(stepScope);
            this.decider.expandNode(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitySelector.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        this.fillLayerList(phaseScope);
        this.initStartNode(phaseScope);
    }

    private void fillLayerList(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        ExhaustiveSearchStepScope<Solution_> stepScope = new ExhaustiveSearchStepScope<Solution_>(phaseScope);
        this.entitySelector.stepStarted(stepScope);
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The entitySelector (" + this.entitySelector + ") has an entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList<ExhaustiveSearchLayer> layerList = new ArrayList<ExhaustiveSearchLayer>((int)entitySize);
        int depth = 0;
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        for (Object t : this.entitySelector) {
            ExhaustiveSearchLayer layer = new ExhaustiveSearchLayer(depth, t);
            int reinitializeVariableCount = this.entitySelector.getEntityDescriptor().countReinitializableVariables(scoreDirector, t);
            if (reinitializeVariableCount == 0) continue;
            ++depth;
            layerList.add(layer);
        }
        ExhaustiveSearchLayer lastLayer = new ExhaustiveSearchLayer(depth, null);
        layerList.add(lastLayer);
        this.entitySelector.stepEnded(stepScope);
        phaseScope.setLayerList(layerList);
    }

    private void initStartNode(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        ExhaustiveSearchLayer startLayer = phaseScope.getLayerList().get(0);
        ExhaustiveSearchNode startNode = new ExhaustiveSearchNode(startLayer, null);
        if (this.decider.isScoreBounderEnabled()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            Object score = scoreDirector.calculateScore();
            startNode.setScore((Score)score);
            ScoreBounder scoreBounder = this.decider.getScoreBounder();
            phaseScope.setBestPessimisticBound((Score)(startLayer.isLastLayer() ? score : scoreBounder.calculatePessimisticBound(scoreDirector, (Score)score)));
            startNode.setOptimisticBound((Score)(startLayer.isLastLayer() ? score : scoreBounder.calculateOptimisticBound(scoreDirector, (Score)score)));
        }
        if (!startLayer.isLastLayer()) {
            phaseScope.addExpandableNode(startNode);
        }
        ((ExhaustiveSearchStepScope)phaseScope.getLastCompletedStepScope()).setExpandingNode(startNode);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    protected void restoreWorkingSolution(ExhaustiveSearchStepScope<Solution_> stepScope) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchNode oldNode = ((ExhaustiveSearchStepScope)((ExhaustiveSearchPhaseScope)phaseScope).getLastCompletedStepScope()).getExpandingNode();
        ExhaustiveSearchNode newNode = stepScope.getExpandingNode();
        ArrayList<Move> oldMoveList = new ArrayList<Move>(oldNode.getDepth());
        ArrayList<Move> newMoveList = new ArrayList<Move>(newNode.getDepth());
        while (oldNode != newNode) {
            int newDepth;
            int oldDepth = oldNode.getDepth();
            if (oldDepth < (newDepth = newNode.getDepth())) {
                newMoveList.add(newNode.getMove());
                newNode = newNode.getParent();
                continue;
            }
            oldMoveList.add(oldNode.getUndoMove());
            oldNode = oldNode.getParent();
        }
        ArrayList<Move> restoreMoveList = new ArrayList<Move>(oldMoveList.size() + newMoveList.size());
        restoreMoveList.addAll(oldMoveList);
        Collections.reverse(newMoveList);
        restoreMoveList.addAll(newMoveList);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        restoreMoveList.forEach(restoreMove -> restoreMove.doMoveOnly(scoreDirector));
        phaseScope.getSolutionDescriptor().setScore(phaseScope.getWorkingSolution(), stepScope.getStartingStepScore());
        if (this.assertWorkingSolutionScoreFromScratch && stepScope.getStartingStepScore() != null) {
            phaseScope.assertPredictedScoreFromScratch(stepScope.getStartingStepScore(), restoreMoveList);
        }
        if (this.assertExpectedWorkingSolutionScore && stepScope.getStartingStepScore() != null) {
            phaseScope.assertExpectedWorkingScore(stepScope.getStartingStepScore(), restoreMoveList);
        }
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
            this.logger.debug("{}    ES step ({}), time spent ({}), treeId ({}), {} best score ({}), selected move count ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getTreeId(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScore(), stepScope.getSelectedMoveCount()});
        }
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.entitySelector.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Exhaustive Search phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex()});
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.entitySelector.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }

    public static class Builder<Solution_>
    extends AbstractPhase.Builder<Solution_> {
        private final Comparator<ExhaustiveSearchNode> nodeComparator;
        private final EntitySelector<Solution_> entitySelector;
        private final ExhaustiveSearchDecider<Solution_> decider;
        private boolean assertWorkingSolutionScoreFromScratch = false;
        private boolean assertExpectedWorkingSolutionScore = false;

        public Builder(int phaseIndex, String logIndentation, Termination<Solution_> phaseTermination, Comparator<ExhaustiveSearchNode> nodeComparator, EntitySelector<Solution_> entitySelector, ExhaustiveSearchDecider<Solution_> decider) {
            super(phaseIndex, logIndentation, phaseTermination);
            this.nodeComparator = nodeComparator;
            this.entitySelector = entitySelector;
            this.decider = decider;
        }

        public void setAssertWorkingSolutionScoreFromScratch(boolean assertWorkingSolutionScoreFromScratch) {
            this.assertWorkingSolutionScoreFromScratch = assertWorkingSolutionScoreFromScratch;
        }

        public void setAssertExpectedWorkingSolutionScore(boolean assertExpectedWorkingSolutionScore) {
            this.assertExpectedWorkingSolutionScore = assertExpectedWorkingSolutionScore;
        }

        @Override
        public DefaultExhaustiveSearchPhase<Solution_> build() {
            return new DefaultExhaustiveSearchPhase(this);
        }
    }
}

