/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.inliner;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.constraint.DefaultConstraintMatchTotal;
import org.optaplanner.core.impl.score.constraint.DefaultIndictment;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public abstract class ScoreInliner<Score_ extends Score<Score_>> {
    private final Map<String, Score_> constraintIdToWeightMap;
    protected final boolean constraintMatchEnabled;
    private final Map<String, DefaultConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    private final Map<Object, DefaultIndictment<Score_>> indictmentMap;

    protected ScoreInliner(Map<Constraint, Score_> constraintToWeightMap, boolean constraintMatchEnabled) {
        this.constraintIdToWeightMap = Objects.requireNonNull(constraintToWeightMap).entrySet().stream().collect(Collectors.toMap(e -> ((Constraint)e.getKey()).getConstraintId(), Map.Entry::getValue));
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.indictmentMap = constraintMatchEnabled ? new LinkedHashMap() : null;
    }

    public abstract Score_ extractScore(int var1);

    public abstract WeightedScoreImpacter buildWeightedScoreImpacter(Constraint var1);

    protected final Runnable addConstraintMatch(Constraint constraint, Score_ constraintWeight, Score_ score, List<Object> justificationList) {
        String constraintPackage = constraint.getConstraintPackage();
        String constraintName = constraint.getConstraintName();
        DefaultConstraintMatchTotal constraintMatchTotal = this.constraintMatchTotalMap.computeIfAbsent(constraint.getConstraintId(), key -> new DefaultConstraintMatchTotal<Score>(constraintPackage, constraintName, (Score)constraintWeight));
        ConstraintMatch constraintMatch = constraintMatchTotal.addConstraintMatch(justificationList, score);
        DefaultIndictment[] indictments = (DefaultIndictment[])justificationList.stream().distinct().map(justification -> {
            DefaultIndictment indictment = this.indictmentMap.computeIfAbsent(justification, key -> new DefaultIndictment(justification, constraintMatch.getScore().zero()));
            indictment.addConstraintMatch(constraintMatch);
            return indictment;
        }).toArray(DefaultIndictment[]::new);
        return () -> {
            constraintMatchTotal.removeConstraintMatch(constraintMatch);
            if (constraintMatchTotal.getConstraintMatchSet().isEmpty()) {
                this.constraintMatchTotalMap.remove(constraint.getConstraintId());
            }
            for (DefaultIndictment indictment : indictments) {
                indictment.removeConstraintMatch(constraintMatch);
                if (!indictment.getConstraintMatchSet().isEmpty()) continue;
                this.indictmentMap.remove(indictment.getJustification());
            }
        };
    }

    public final Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.constraintMatchTotalMap;
    }

    public final Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.indictmentMap;
    }

    protected final Score_ getConstraintWeight(Constraint constraint) {
        Score constraintWeight = (Score)this.constraintIdToWeightMap.get(constraint.getConstraintId());
        if (constraintWeight == null || constraintWeight.isZero()) {
            throw new IllegalArgumentException("Impossible state: The constraintWeight (" + constraintWeight + ") cannot be zero, constraint (" + constraint + ") should have been culled during node creation.");
        }
        return (Score_)constraintWeight;
    }
}

