/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverJob<Solution_, ProblemId_>
implements SolverJob<Solution_, ProblemId_>,
Callable<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverJob.class);
    private final DefaultSolverManager<Solution_, ProblemId_> solverManager;
    private final DefaultSolver<Solution_> solver;
    private final ProblemId_ problemId;
    private final Function<? super ProblemId_, ? extends Solution_> problemFinder;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private final AtomicReference<SolverStatus> solverStatusReference;
    private CountDownLatch terminatedLatch;
    private Future<Solution_> future;

    public DefaultSolverJob(DefaultSolverManager<Solution_, ProblemId_> solverManager, Solver<Solution_> solver, ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.solverManager = solverManager;
        this.problemId = problemId;
        if (!(solver instanceof DefaultSolver)) {
            throw new IllegalStateException("Impossible state: solver is not instance of " + DefaultSolver.class.getSimpleName() + ".");
        }
        this.solver = (DefaultSolver)solver;
        this.problemFinder = problemFinder;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
        this.solverStatusReference = new AtomicReference<SolverStatus>(SolverStatus.SOLVING_SCHEDULED);
        this.terminatedLatch = new CountDownLatch(1);
    }

    public void setFuture(Future<Solution_> future) {
        this.future = future;
    }

    @Override
    public ProblemId_ getProblemId() {
        return this.problemId;
    }

    @Override
    public SolverStatus getSolverStatus() {
        return this.solverStatusReference.get();
    }

    @Override
    public Solution_ call() {
        SolverStatus solverStatus = this.solverStatusReference.getAndSet(SolverStatus.SOLVING_ACTIVE);
        if (solverStatus != SolverStatus.SOLVING_SCHEDULED) {
            return this.problemFinder.apply(this.problemId);
        }
        try {
            Solution_ problem = this.problemFinder.apply(this.problemId);
            Solution_ finalBestSolution = this.solver.solve(problem);
            if (this.finalBestSolutionConsumer != null) {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            Solution_ Solution_ = finalBestSolution;
            return Solution_;
        }
        catch (Exception e) {
            this.exceptionHandler.accept(this.problemId, e);
            throw new IllegalStateException("Solving failed for problemId (" + this.problemId + ").", e);
        }
        finally {
            this.solvingTerminated();
        }
    }

    private void solvingTerminated() {
        this.solverStatusReference.set(SolverStatus.NOT_SOLVING);
        this.solverManager.unregisterSolverJob(this.problemId);
        this.terminatedLatch.countDown();
    }

    @Override
    public void terminateEarly() {
        this.future.cancel(false);
        SolverStatus solverStatus = this.solverStatusReference.get();
        switch (solverStatus) {
            case SOLVING_SCHEDULED: {
                this.solvingTerminated();
                break;
            }
            case SOLVING_ACTIVE: {
                this.solver.terminateEarly();
                break;
            }
            case NOT_SOLVING: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported solverStatus (" + solverStatus + ").");
            }
        }
        try {
            this.terminatedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("The terminateEarly() call is interrupted.", (Throwable)e);
        }
    }

    @Override
    public Solution_ getFinalBestSolution() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public Duration getSolvingDuration() {
        SolverScope<Solution_> solverScope = this.solver.getSolverScope();
        Long startingSystemTimeMillis = solverScope.getStartingSystemTimeMillis();
        if (startingSystemTimeMillis == null) {
            return Duration.ZERO;
        }
        Long endingSystemTimeMillis = solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return Duration.ofMillis(endingSystemTimeMillis - startingSystemTimeMillis);
    }
}

