/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import org.kie.kogito.jobs.ExpirationTime;

public class DurationExpirationTime
implements ExpirationTime {
    private final ZonedDateTime expirationTime;
    private Long repeatInterval;
    private Integer repeatLimit;

    private DurationExpirationTime(ZonedDateTime expirationTime, Long repeatInterval, Integer repeatLimit) {
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.repeatInterval = repeatInterval;
        this.repeatLimit = repeatLimit;
    }

    @Override
    public ZonedDateTime get() {
        return this.expirationTime;
    }

    @Override
    public Long repeatInterval() {
        return this.repeatInterval;
    }

    @Override
    public Integer repeatLimit() {
        return this.repeatLimit;
    }

    public static DurationExpirationTime now() {
        return new DurationExpirationTime(ZonedDateTime.now(), null, 0);
    }

    public static DurationExpirationTime after(long delay) {
        return DurationExpirationTime.after(delay, ChronoUnit.MILLIS);
    }

    public static DurationExpirationTime after(long delay, TemporalUnit unit) {
        return new DurationExpirationTime(ZonedDateTime.now().plus(delay, unit), null, 0);
    }

    public static DurationExpirationTime repeat(long delay) {
        return DurationExpirationTime.repeat(delay, null, ChronoUnit.MILLIS);
    }

    public static DurationExpirationTime repeat(long delay, Long repeatInterval) {
        return DurationExpirationTime.repeat(delay, repeatInterval, ChronoUnit.MILLIS);
    }

    public static DurationExpirationTime repeat(long delay, Long repeatInterval, Integer repeatLimit) {
        return DurationExpirationTime.repeat(delay, repeatInterval, repeatLimit, ChronoUnit.MILLIS);
    }

    public static DurationExpirationTime repeat(long delay, Long repeatInterval, TemporalUnit unit) {
        return new DurationExpirationTime(ZonedDateTime.now().plus(delay, unit), repeatInterval, -1);
    }

    public static DurationExpirationTime repeat(long delay, Long repeatInterval, Integer limit, TemporalUnit unit) {
        return new DurationExpirationTime(ZonedDateTime.now().plus(delay, unit), repeatInterval, limit);
    }
}

