/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.statics;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.wiring.statics.SimpleInstanceCreator;
import org.kie.api.internal.runtime.KieRuntimeService;
import org.kie.api.internal.runtime.KieRuntimes;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.internal.weaver.KieWeaverService;
import org.kie.api.internal.weaver.KieWeavers;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.internal.services.KieWeaversImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(StaticServiceRegistry.class);
    static final StaticServiceRegistry INSTANCE = new StaticServiceRegistry();
    private Map<Class<?>, Object> serviceMap = new HashMap();
    private Map<String, Constructor<?>> constructorMap = new HashMap();

    protected StaticServiceRegistry() {
        this.wireServices();
    }

    protected void wireServices() {
        this.registerService("org.drools.wiring.api.ComponentsSupplier", "org.drools.wiring.statics.StaticComponentsSupplier", true);
        this.registerService("org.kie.api.io.KieResources", "org.drools.core.io.impl.ResourceFactoryServiceImpl", true);
        this.registerService("org.kie.api.concurrent.KieExecutors", "org.drools.core.concurrent.ExecutorProviderImpl", true);
        this.registerService("org.kie.api.KieServices", "org.drools.compiler.kie.builder.impl.KieServicesImpl", false);
        this.registerService("org.kie.internal.builder.KnowledgeBuilderFactoryService", "org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl", true);
        this.registerService("org.kie.api.internal.assembler.KieAssemblers", "org.drools.wiring.statics.StaticKieAssemblers", true);
        this.registerService("org.kie.api.internal.runtime.KieRuntimes", "org.kie.internal.services.KieRuntimesImpl", true);
        this.registerService("org.kie.api.internal.weaver.KieWeavers", "org.kie.internal.services.KieWeaversImpl", true);
        this.registerService("org.drools.compiler.kie.builder.impl.InternalKieModuleProvider", "org.drools.modelcompiler.CanonicalKieModuleProvider", true);
        this.registerService("org.drools.compiler.compiler.DecisionTableProvider", "org.drools.decisiontable.DecisionTableProviderImpl", false);
        this.registerService("org.drools.core.reteoo.RuntimeComponentFactory", "org.drools.kiesession.factory.RuntimeComponentFactoryImpl", false);
        this.registerService("org.drools.core.marshalling.impl.ProcessMarshallerFactoryService", "org.jbpm.marshalling.impl.ProcessMarshallerFactoryServiceImpl", false);
        this.registerService("org.drools.core.runtime.process.ProcessRuntimeFactoryService", "org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl", false);
        this.registerService("org.drools.core.base.XMLSupport", "org.drools.xml.support.XMLSupportImpl", false);
        this.constructorMap.put("TimerService", SimpleInstanceCreator.constructor("org.drools.core.time.impl.JDKTimerService"));
        this.registerKieRuntimeService("org.kie.pmml.api.runtime.PMMLRuntime", "org.kie.pmml.evaluator.core.service.PMMLRuntimeService", false);
        this.registerKieWeaverService("org.kie.pmml.evaluator.assembler.PMMLWeaverService", false);
        this.registerService(KieMarshallers.class.getCanonicalName(), "org.drools.serialization.protobuf.MarshallerProviderImpl", false);
        this.registerService("org.drools.compiler.kie.builder.impl.CompilationCacheProvider", "org.drools.serialization.protobuf.CompilationCacheProviderImpl", false);
    }

    protected void registerService(String service, String implementation, boolean mandatory) {
        try {
            this.serviceMap.put(Class.forName(service), SimpleInstanceCreator.instance(implementation));
        }
        catch (Exception e) {
            this.commonManageException(service, e, mandatory);
        }
    }

    private void registerKieRuntimeService(String runtimeName, String kieRuntimeServiceImplementation, boolean mandatory) {
        try {
            KieRuntimeService kieRuntimeService = (KieRuntimeService)SimpleInstanceCreator.instance(kieRuntimeServiceImplementation);
            ((KieRuntimes)this.serviceMap.get(KieRuntimes.class)).getRuntimes().put(runtimeName, kieRuntimeService);
        }
        catch (Exception e) {
            this.commonManageException("KieRuntimes", e, mandatory);
        }
    }

    private void registerKieWeaverService(String kieWeaverServiceImplementation, boolean mandatory) {
        try {
            KieWeaversImpl kieWeavers = (KieWeaversImpl)this.serviceMap.get(KieWeavers.class);
            KieWeaverService kieWeaverService = (KieWeaverService)SimpleInstanceCreator.instance(kieWeaverServiceImplementation);
            kieWeavers.accept(kieWeaverService);
        }
        catch (Exception e) {
            this.commonManageException("KieWeaverService", e, mandatory);
        }
    }

    private void commonManageException(String ignoredServiceType, Exception e, boolean mandatory) {
        if (mandatory) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        log.debug("Ignored non-mandatory {} service load error", (Object)ignoredServiceType, (Object)e);
    }

    public <T> T get(Class<T> cls) {
        return (T)this.serviceMap.get(cls);
    }

    public <T> List<T> getAll(Class<T> cls) {
        return Collections.singletonList(this.get(cls));
    }

    public <T> T newInstance(String name) {
        try {
            return (T)this.constructorMap.get(name).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

