/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.event.impl;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventConverter;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.SubscriptionInfo;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.kie.kogito.services.event.EventConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConsumer<M extends Model, D, T extends AbstractProcessDataEvent<D>> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMessageConsumer.class);
    private Process<M> process;
    private Application application;
    private String trigger;
    private EventConsumer<M> eventConsumer;
    private Class<?> outputClass;
    private EventConverter<String> eventConverter;

    public AbstractMessageConsumer() {
    }

    public AbstractMessageConsumer(Application application, Process<M> process, String trigger, EventConsumerFactory eventConsumerFactory, EventReceiver eventReceiver, Class<D> dataEventConverter, Class<T> cloudEventConverter, boolean useCloudEvents, ProcessService processService, ExecutorService executorService, EventConverter<String> eventConverter) {
        this.init(application, process, trigger, eventConsumerFactory, eventReceiver, dataEventConverter, cloudEventConverter, useCloudEvents, processService, executorService, eventConverter);
    }

    public void init(Application application, Process<M> process, String trigger, EventConsumerFactory eventConsumerFactory, EventReceiver eventReceiver, Class<D> dataEventClass, Class<T> cloudEventClass, boolean useCloudEvents, ProcessService processService, ExecutorService executorService, EventConverter<String> eventConverter) {
        this.process = process;
        this.application = application;
        this.trigger = trigger;
        this.eventConverter = eventConverter;
        this.eventConsumer = eventConsumerFactory.get(processService, executorService, this::eventToModel, useCloudEvents);
        if (useCloudEvents) {
            this.outputClass = cloudEventClass;
            eventReceiver.subscribe(this::consumeCloud, new SubscriptionInfo(eventConverter, cloudEventClass, Optional.of(trigger)));
        } else {
            this.outputClass = dataEventClass;
            eventReceiver.subscribe(this::consumeNotCloud, new SubscriptionInfo(eventConverter, dataEventClass, Optional.of(trigger)));
        }
        logger.info("Consumer for {} started", (Object)trigger);
    }

    protected CompletionStage<?> consumeCloud(T payload) {
        return this.consume(payload);
    }

    protected CompletionStage<?> consumeNotCloud(D payload) {
        return this.consume(payload);
    }

    private CompletionStage<?> consume(Object payload) {
        logger.trace("Received {} for trigger {}", payload, (Object)this.trigger);
        CompletionStage<Object> result = this.eventConsumer.consume(this.application, this.process, payload, this.trigger);
        if (logger.isTraceEnabled()) {
            result = result.thenAccept(v -> logger.trace("Completed {} for trigger {}", payload, (Object)this.trigger));
        }
        logger.trace("Dispatched {} for trigger {}", payload, (Object)this.trigger);
        return result;
    }

    protected abstract M eventToModel(D var1);
}

