/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.jobs.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.JobId;
import org.kie.kogito.jobs.JobIdResolver;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.jobs.impl.InMemoryJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyInMemoryJobService
extends InMemoryJobService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyInMemoryJobService.class);
    private KogitoProcessRuntime processRuntime;

    public LegacyInMemoryJobService(KogitoProcessRuntime processRuntime, UnitOfWorkManager unitOfWorkManager) {
        super(null, unitOfWorkManager);
        this.processRuntime = processRuntime;
    }

    @Override
    public Runnable getSignalProcessInstanceCommand(ProcessInstanceJobDescription description, boolean remove, int limit) {
        String id = description.id();
        AtomicInteger counter = new AtomicInteger(limit);
        return () -> {
            try {
                UnitOfWorkExecutor.executeInUnitOfWork(this.unitOfWorkManager, () -> {
                    KogitoProcessInstance pi = this.processRuntime.getProcessInstance(description.processInstanceId());
                    if (pi != null) {
                        JobId jobId = JobIdResolver.resolve((String)id);
                        pi.signalEvent(jobId.signal(), jobId.payload(new Object[]{counter.decrementAndGet()}));
                        if (counter.get() == 0) {
                            this.cancelJob(id, false);
                        }
                    } else {
                        this.cancelJob(id, false);
                    }
                    return null;
                });
                LOGGER.debug("Job {} completed", (Object)id);
            }
            finally {
                if (remove) {
                    this.cancelJob(id);
                }
            }
        };
    }

    @Override
    protected Runnable processJobByDescription(ProcessJobDescription description) {
        return this.processCommand(description, true);
    }

    private Runnable processCommand(ProcessJobDescription description, boolean remove) {
        String id = description.id();
        AtomicInteger counter = new AtomicInteger(description.expirationTime().repeatLimit());
        String processId = description.processId();
        return () -> {
            try {
                LOGGER.debug("Job {} started", (Object)id);
                UnitOfWorkExecutor.executeInUnitOfWork(this.unitOfWorkManager, () -> {
                    KogitoProcessInstance pi = this.processRuntime.createProcessInstance(processId, null);
                    if (pi != null) {
                        this.processRuntime.startProcessInstance(pi.getStringId(), "timer");
                    }
                    return null;
                });
                if (counter.decrementAndGet() == 0) {
                    this.cancelJob(id, false);
                }
                LOGGER.debug("Job {} completed", (Object)id);
            }
            finally {
                if (remove) {
                    this.cancelJob(id);
                }
            }
        };
    }

    @Override
    protected Runnable repeatableProcessJobByDescription(ProcessJobDescription description) {
        return this.processCommand(description, false);
    }
}

