/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;

public class PreparationWeighting
implements Weighting {
    private final Weighting userWeighting;

    public PreparationWeighting(Weighting userWeighting) {
        this.userWeighting = userWeighting;
    }

    @Override
    public final double getMinWeight(double distance) {
        return this.userWeighting.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        CHEdgeIteratorState tmp = (CHEdgeIteratorState)edgeState;
        if (tmp.isShortcut()) {
            return tmp.getWeight();
        }
        return this.userWeighting.calcWeight(edgeState, reverse, prevOrNextEdgeId);
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        if (edgeState instanceof CHEdgeIteratorState && ((CHEdgeIteratorState)edgeState).isShortcut()) {
            throw new IllegalStateException("calcMillis should only be called on original edges");
        }
        return this.userWeighting.calcMillis(edgeState, reverse, prevOrNextEdgeId);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.userWeighting.getFlagEncoder();
    }

    @Override
    public boolean matches(HintsMap map) {
        return this.getName().equals(map.getWeighting()) && this.userWeighting.getFlagEncoder().toString().equals(map.getVehicle());
    }

    @Override
    public String getName() {
        return "prepare|" + this.userWeighting.getName();
    }

    public String toString() {
        return this.getName();
    }
}

