/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class ShortFastestWeighting
extends FastestWeighting {
    private static final String NAME = "short_fastest";
    private static final String TIME_FACTOR = "short_fastest.time_factor";
    private static final String DISTANCE_FACTOR = "short_fastest.distance_factor";
    private final double distanceFactor;
    private final double timeFactor;

    public ShortFastestWeighting(FlagEncoder encoder, PMap map) {
        super(encoder);
        this.timeFactor = this.checkBounds(TIME_FACTOR, map.getDouble(TIME_FACTOR, 1.0));
        this.distanceFactor = this.checkBounds(DISTANCE_FACTOR, map.getDouble(DISTANCE_FACTOR, 0.07));
        if (this.timeFactor < 1.0E-5 && this.distanceFactor < 1.0E-5) {
            throw new IllegalArgumentException("[short_fastest] one of distance_factor or time_factor has to be non-zero");
        }
    }

    public ShortFastestWeighting(FlagEncoder encoder, double distanceFactor) {
        super(encoder);
        this.distanceFactor = this.checkBounds(DISTANCE_FACTOR, distanceFactor);
        this.timeFactor = 1.0;
    }

    @Override
    public double getMinWeight(double distance) {
        return super.getMinWeight(distance) * this.timeFactor + distance * this.distanceFactor;
    }

    @Override
    public double calcWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        double time = super.calcWeight(edge, reverse, prevOrNextEdgeId);
        return time * this.timeFactor + edge.getDistance() * this.distanceFactor;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private double checkBounds(String key, double val) {
        if (val < 0.0 || val > 10.0) {
            throw new IllegalArgumentException(key + " has invalid range should be within [0, 10]");
        }
        return val;
    }
}

