/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.cache.ConnectionCache;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.pool.DataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.runtime.AgroalConnectionConfigurer;
import io.quarkus.agroal.runtime.AgroalEventLoggingListener;
import io.quarkus.agroal.runtime.AgroalVaultCredentialsProviderPassword;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourceJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.DataSourceSupport;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourcesJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.JdbcDriver;
import io.quarkus.agroal.runtime.QuarkusNettyConnectionCache;
import io.quarkus.agroal.runtime.QuarkusSimpleConnectionCache;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.agroal.runtime.UnknownDbAgroalConnectionConfigurer;
import io.quarkus.arc.Arc;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Singleton;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.logging.Logger;

@Singleton
public class DataSources {
    private static final Logger log = Logger.getLogger((String)DataSources.class.getName());
    private final DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig;
    private final DataSourcesRuntimeConfig dataSourcesRuntimeConfig;
    private final DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig;
    private final DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig;
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final DataSourceSupport dataSourceSupport;
    private final Instance<AgroalPoolInterceptor> agroalPoolInterceptors;
    private final ConcurrentMap<String, AgroalDataSource> dataSources = new ConcurrentHashMap<String, AgroalDataSource>();

    public DataSources(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, DataSourceSupport dataSourceSupport, @Any Instance<AgroalPoolInterceptor> agroalPoolInterceptors) {
        this.dataSourcesBuildTimeConfig = dataSourcesBuildTimeConfig;
        this.dataSourcesRuntimeConfig = dataSourcesRuntimeConfig;
        this.dataSourcesJdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig;
        this.dataSourcesJdbcRuntimeConfig = dataSourcesJdbcRuntimeConfig;
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.dataSourceSupport = dataSourceSupport;
        this.agroalPoolInterceptors = agroalPoolInterceptors;
    }

    public static AgroalDataSource fromName(String dataSourceName) {
        return ((DataSources)Arc.container().instance(DataSources.class, new Annotation[0]).get()).getDataSource(dataSourceName);
    }

    public AgroalDataSource getDataSource(String dataSourceName) {
        return this.dataSources.computeIfAbsent(dataSourceName, new Function<String, AgroalDataSource>(){

            @Override
            public AgroalDataSource apply(String s) {
                return DataSources.this.doCreateDataSource(s);
            }
        });
    }

    public AgroalDataSource doCreateDataSource(String dataSourceName) {
        Class<?> driver;
        if (!this.dataSourceSupport.entries.containsKey(dataSourceName)) {
            throw new IllegalArgumentException("No datasource named '" + dataSourceName + "' exists");
        }
        DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig = this.getDataSourceJdbcBuildTimeConfig(dataSourceName);
        DataSourceRuntimeConfig dataSourceRuntimeConfig = this.getDataSourceRuntimeConfig(dataSourceName);
        DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig = this.getDataSourceJdbcRuntimeConfig(dataSourceName);
        DataSourceSupport.Entry matchingSupportEntry = this.dataSourceSupport.entries.get(dataSourceName);
        if (!dataSourceJdbcRuntimeConfig.url.isPresent()) {
            Object errorMessage = DataSourceUtil.isDefault((String)dataSourceName) ? "quarkus.datasource.jdbc.url has not been defined" : "quarkus.datasource." + dataSourceName + ".jdbc.url has not been defined";
            return new UnconfiguredDataSource((String)errorMessage);
        }
        DataSources.loadDriversInTCCL();
        String resolvedDriverClass = matchingSupportEntry.resolvedDriverClass;
        try {
            driver = Class.forName(resolvedDriverClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load the datasource driver " + resolvedDriverClass + " for datasource " + dataSourceName, e);
        }
        String resolvedDbKind = matchingSupportEntry.resolvedDbKind;
        AgroalConnectionConfigurer agroalConnectionConfigurer = (AgroalConnectionConfigurer)Arc.container().instance(AgroalConnectionConfigurer.class, new Annotation[]{new JdbcDriver.JdbcDriverLiteral(resolvedDbKind)}).orElse((Object)new UnknownDbAgroalConnectionConfigurer());
        AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
        if (!dataSourceJdbcRuntimeConfig.poolingEnabled) {
            dataSourceConfiguration.dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.AGROAL_POOLLESS);
        }
        AgroalConnectionPoolConfigurationSupplier poolConfiguration = dataSourceConfiguration.connectionPoolConfiguration();
        AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = poolConfiguration.connectionFactoryConfiguration();
        boolean mpMetricsPresent = this.dataSourceSupport.mpMetricsPresent;
        this.applyNewConfiguration(dataSourceConfiguration, poolConfiguration, connectionFactoryConfiguration, driver, dataSourceJdbcBuildTimeConfig, dataSourceRuntimeConfig, dataSourceJdbcRuntimeConfig, mpMetricsPresent);
        if (this.dataSourceSupport.disableSslSupport) {
            agroalConnectionConfigurer.disableSslSupport(resolvedDbKind, dataSourceConfiguration);
        }
        try {
            Class.forName("io.netty.util.concurrent.FastThreadLocal", true, Thread.currentThread().getContextClassLoader());
            dataSourceConfiguration.connectionPoolConfiguration().connectionCache((ConnectionCache)new QuarkusNettyConnectionCache());
        }
        catch (ClassNotFoundException e) {
            dataSourceConfiguration.connectionPoolConfiguration().connectionCache((ConnectionCache)new QuarkusSimpleConnectionCache());
        }
        agroalConnectionConfigurer.setExceptionSorter(resolvedDbKind, dataSourceConfiguration);
        AgroalDataSourceConfiguration agroalConfiguration = dataSourceConfiguration.get();
        DataSource dataSource = new DataSource(agroalConfiguration, new AgroalDataSourceListener[]{new AgroalEventLoggingListener(dataSourceName, agroalConfiguration.connectionPoolConfiguration().transactionRequirement() == AgroalConnectionPoolConfiguration.TransactionRequirement.WARN)});
        log.debugv("Started datasource {0} connected to {1}", (Object)dataSourceName, (Object)agroalConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl());
        Collection interceptorList = this.agroalPoolInterceptors.select(new Annotation[]{dataSourceName == null || DataSourceUtil.isDefault((String)dataSourceName) ? Default.Literal.INSTANCE : new DataSource.DataSourceLiteral(dataSourceName)}).stream().collect(Collectors.toList());
        if (!interceptorList.isEmpty()) {
            dataSource.setPoolInterceptors(interceptorList);
        }
        return dataSource;
    }

    private void applyNewConfiguration(AgroalDataSourceConfigurationSupplier dataSourceConfiguration, AgroalConnectionPoolConfigurationSupplier poolConfiguration, AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration, Class<?> driver, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig, boolean mpMetricsPresent) {
        connectionFactoryConfiguration.jdbcUrl(dataSourceJdbcRuntimeConfig.url.get());
        connectionFactoryConfiguration.connectionProviderClass(driver);
        connectionFactoryConfiguration.trackJdbcResources(dataSourceJdbcRuntimeConfig.detectStatementLeaks);
        if (dataSourceJdbcRuntimeConfig.transactionIsolationLevel.isPresent()) {
            connectionFactoryConfiguration.jdbcTransactionIsolation(dataSourceJdbcRuntimeConfig.transactionIsolationLevel.get());
        }
        if (dataSourceJdbcBuildTimeConfig.transactions != TransactionIntegration.DISABLED) {
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration(this.transactionManager, this.transactionSynchronizationRegistry);
            poolConfiguration.transactionIntegration((io.agroal.api.transaction.TransactionIntegration)txIntegration);
        }
        if (dataSourceJdbcRuntimeConfig.newConnectionSql.isPresent()) {
            connectionFactoryConfiguration.initialSql(dataSourceJdbcRuntimeConfig.newConnectionSql.get());
        }
        if (dataSourceJdbcBuildTimeConfig.enableMetrics.isPresent()) {
            dataSourceConfiguration.metricsEnabled(dataSourceJdbcBuildTimeConfig.enableMetrics.get().booleanValue());
        } else {
            dataSourceConfiguration.metricsEnabled(this.dataSourcesBuildTimeConfig.metricsEnabled && mpMetricsPresent);
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            connectionFactoryConfiguration.principal((Principal)new NamePrincipal((String)dataSourceRuntimeConfig.username.get()));
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            connectionFactoryConfiguration.credential((Object)new SimplePassword((String)dataSourceRuntimeConfig.password.get()));
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            connectionFactoryConfiguration.credential((Object)new AgroalVaultCredentialsProviderPassword(name, credentialsProvider));
        }
        for (Map.Entry entry : dataSourceJdbcRuntimeConfig.additionalJdbcProperties.entrySet()) {
            connectionFactoryConfiguration.jdbcProperty((String)entry.getKey(), (String)entry.getValue());
        }
        poolConfiguration.minSize(dataSourceJdbcRuntimeConfig.minSize);
        poolConfiguration.maxSize(dataSourceJdbcRuntimeConfig.maxSize);
        if (dataSourceJdbcRuntimeConfig.initialSize.isPresent() && dataSourceJdbcRuntimeConfig.initialSize.getAsInt() > 0) {
            poolConfiguration.initialSize(dataSourceJdbcRuntimeConfig.initialSize.getAsInt());
        }
        poolConfiguration.connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator());
        if (dataSourceJdbcRuntimeConfig.acquisitionTimeout.isPresent()) {
            poolConfiguration.acquisitionTimeout(dataSourceJdbcRuntimeConfig.acquisitionTimeout.get());
        }
        if (dataSourceJdbcRuntimeConfig.backgroundValidationInterval.isPresent()) {
            poolConfiguration.validationTimeout(dataSourceJdbcRuntimeConfig.backgroundValidationInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.foregroundValidationInterval.isPresent()) {
            poolConfiguration.idleValidationTimeout(dataSourceJdbcRuntimeConfig.foregroundValidationInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.validationQuerySql.isPresent()) {
            final String validationQuery = dataSourceJdbcRuntimeConfig.validationQuerySql.get();
            poolConfiguration.connectionValidator(new AgroalConnectionPoolConfiguration.ConnectionValidator(){

                public boolean isValid(Connection connection) {
                    boolean bl;
                    block8: {
                        Statement stmt = connection.createStatement();
                        try {
                            stmt.execute(validationQuery);
                            bl = true;
                            if (stmt == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                log.warn((Object)"Connection validation failed", (Throwable)e);
                                return false;
                            }
                        }
                        stmt.close();
                    }
                    return bl;
                }
            });
        }
        if (dataSourceJdbcRuntimeConfig.idleRemovalInterval.isPresent()) {
            poolConfiguration.reapTimeout(dataSourceJdbcRuntimeConfig.idleRemovalInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.leakDetectionInterval.isPresent()) {
            poolConfiguration.leakTimeout(dataSourceJdbcRuntimeConfig.leakDetectionInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.maxLifetime.isPresent()) {
            poolConfiguration.maxLifetime(dataSourceJdbcRuntimeConfig.maxLifetime.get());
        }
        if (dataSourceJdbcRuntimeConfig.transactionRequirement.isPresent()) {
            poolConfiguration.transactionRequirement(dataSourceJdbcRuntimeConfig.transactionRequirement.get());
        }
        poolConfiguration.enhancedLeakReport(dataSourceJdbcRuntimeConfig.extendedLeakReport);
        poolConfiguration.flushOnClose(dataSourceJdbcRuntimeConfig.flushOnClose);
    }

    public DataSourceBuildTimeConfig getDataSourceBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesBuildTimeConfig.defaultDataSource;
        }
        DataSourceBuildTimeConfig namedConfig = (DataSourceBuildTimeConfig)this.dataSourcesBuildTimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new DataSourceBuildTimeConfig();
    }

    public DataSourceJdbcBuildTimeConfig getDataSourceJdbcBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesJdbcBuildTimeConfig.jdbc;
        }
        DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig namedOuterConfig = this.dataSourcesJdbcBuildTimeConfig.namedDataSources.get(dataSourceName);
        return namedOuterConfig != null ? namedOuterConfig.jdbc : new DataSourceJdbcBuildTimeConfig();
    }

    public DataSourceRuntimeConfig getDataSourceRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesRuntimeConfig.defaultDataSource;
        }
        DataSourceRuntimeConfig namedConfig = (DataSourceRuntimeConfig)this.dataSourcesRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new DataSourceRuntimeConfig();
    }

    public DataSourceJdbcRuntimeConfig getDataSourceJdbcRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesJdbcRuntimeConfig.jdbc;
        }
        DataSourcesJdbcRuntimeConfig.DataSourceJdbcOuterNamedRuntimeConfig namedOuterConfig = this.dataSourcesJdbcRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedOuterConfig != null ? namedOuterConfig.jdbc : new DataSourceJdbcRuntimeConfig();
    }

    private static void loadDriversInTCCL() {
        ServiceLoader<Driver> drivers = ServiceLoader.load(Driver.class);
        Iterator<Driver> iterator = drivers.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (Throwable throwable) {}
        }
    }

    @PreDestroy
    public void stop() {
        for (AgroalDataSource dataSource : this.dataSources.values()) {
            if (dataSource == null) continue;
            dataSource.close();
        }
    }
}

