/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.score.descriptor;

import java.lang.reflect.Member;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.score.AbstractBendableScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.score.buildin.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class ScoreDescriptor {
    @PlanningScore
    private static final Object PLANNING_SCORE = new Object();
    private final MemberAccessor scoreMemberAccessor;
    private final ScoreDefinition<?> scoreDefinition;

    private ScoreDescriptor(MemberAccessor scoreMemberAccessor, ScoreDefinition<?> scoreDefinition) {
        this.scoreMemberAccessor = scoreMemberAccessor;
        this.scoreDefinition = scoreDefinition;
    }

    public static ScoreDescriptor buildScoreDescriptor(DescriptorPolicy descriptorPolicy, Member member, Class<?> solutionClass) {
        MemberAccessor scoreMemberAccessor = ScoreDescriptor.buildScoreMemberAccessor(descriptorPolicy, member);
        Class<? extends Score<?>> scoreType = ScoreDescriptor.extractScoreType(scoreMemberAccessor, solutionClass);
        PlanningScore annotation = ScoreDescriptor.extractPlanningScoreAnnotation(scoreMemberAccessor);
        ScoreDefinition<?> scoreDefinition = ScoreDescriptor.buildScoreDefinition(solutionClass, scoreMemberAccessor, scoreType, annotation);
        return new ScoreDescriptor(scoreMemberAccessor, scoreDefinition);
    }

    private static MemberAccessor buildScoreMemberAccessor(DescriptorPolicy descriptorPolicy, Member member) {
        return MemberAccessorFactory.buildMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, PlanningScore.class, descriptorPolicy.getDomainAccessType(), descriptorPolicy.getGeneratedMemberAccessorMap());
    }

    private static Class<? extends Score<?>> extractScoreType(MemberAccessor scoreMemberAccessor, Class<?> solutionClass) {
        Class<?> memberType = scoreMemberAccessor.getType();
        if (!Score.class.isAssignableFrom(memberType)) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that does not return a subtype of Score.");
        }
        if (memberType == Score.class) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that doesn't return a non-abstract " + Score.class.getSimpleName() + " class.\nMaybe make it return " + HardSoftScore.class.getSimpleName() + " or another specific " + Score.class.getSimpleName() + " implementation.");
        }
        return memberType;
    }

    private static PlanningScore extractPlanningScoreAnnotation(MemberAccessor scoreMemberAccessor) {
        PlanningScore annotation = scoreMemberAccessor.getAnnotation(PlanningScore.class);
        if (annotation != null) {
            return annotation;
        }
        try {
            return ScoreDescriptor.class.getDeclaredField("PLANNING_SCORE").getAnnotation(PlanningScore.class);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Impossible situation: the field (PLANNING_SCORE) must exist.", e);
        }
    }

    private static ScoreDefinition<?> buildScoreDefinition(Class<?> solutionClass, MemberAccessor scoreMemberAccessor, Class<? extends Score<?>> scoreType, PlanningScore annotation) {
        Class<? extends ScoreDefinition> scoreDefinitionClass = annotation.scoreDefinitionClass();
        int bendableHardLevelsSize = annotation.bendableHardLevelsSize();
        int bendableSoftLevelsSize = annotation.bendableSoftLevelsSize();
        if (scoreDefinitionClass != PlanningScore.NullScoreDefinition.class) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that has a scoreDefinition (" + scoreDefinitionClass + ") that must not have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") or a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
            }
            return ConfigUtils.newInstance(() -> scoreMemberAccessor + " with @" + PlanningScore.class.getSimpleName(), "scoreDefinitionClass", scoreDefinitionClass);
        }
        if (!AbstractBendableScore.class.isAssignableFrom(scoreType)) {
            if (bendableHardLevelsSize != -1 || bendableSoftLevelsSize != -1) {
                throw new IllegalArgumentException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that must not have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") or a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
            }
            if (scoreType.equals(SimpleScore.class)) {
                return new SimpleScoreDefinition();
            }
            if (scoreType.equals(SimpleLongScore.class)) {
                return new SimpleLongScoreDefinition();
            }
            if (scoreType.equals(SimpleBigDecimalScore.class)) {
                return new SimpleBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardSoftScore.class)) {
                return new HardSoftScoreDefinition();
            }
            if (scoreType.equals(HardSoftLongScore.class)) {
                return new HardSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardSoftBigDecimalScore.class)) {
                return new HardSoftBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftScore.class)) {
                return new HardMediumSoftScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftLongScore.class)) {
                return new HardMediumSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftBigDecimalScore.class)) {
                return new HardMediumSoftBigDecimalScoreDefinition();
            }
            throw new IllegalArgumentException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the @" + PlanningScore.class.getSimpleName() + " annotation.");
        }
        if (bendableHardLevelsSize == -1 || bendableSoftLevelsSize == -1) {
            throw new IllegalArgumentException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that must have a bendableHardLevelsSize (" + bendableHardLevelsSize + ") and a bendableSoftLevelsSize (" + bendableSoftLevelsSize + ").");
        }
        if (scoreType.equals(BendableScore.class)) {
            return new BendableScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableLongScore.class)) {
            return new BendableLongScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableBigDecimalScore.class)) {
            return new BendableBigDecimalScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        throw new IllegalArgumentException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + scoreMemberAccessor + ") that returns a bendable scoreType (" + scoreType + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the annotation.");
    }

    public ScoreDefinition<?> getScoreDefinition() {
        return this.scoreDefinition;
    }

    public Class<? extends Score<?>> getScoreClass() {
        return this.scoreDefinition.getScoreClass();
    }

    public Score<?> getScore(Object solution) {
        return (Score)this.scoreMemberAccessor.executeGetter(solution);
    }

    public void setScore(Object solution, Score<?> score) {
        this.scoreMemberAccessor.executeSetter(solution, score);
    }

    public void failFastOnDuplicateMember(DescriptorPolicy descriptorPolicy, Member member, Class<?> solutionClass) {
        MemberAccessor memberAccessor = ScoreDescriptor.buildScoreMemberAccessor(descriptorPolicy, member);
        if (!this.scoreMemberAccessor.getName().equals(memberAccessor.getName()) || !this.scoreMemberAccessor.getClass().equals(memberAccessor.getClass())) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") has a @" + PlanningScore.class.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member (" + this.scoreMemberAccessor + ").\nMaybe the annotation is defined on both the field and its getter.");
        }
    }
}

