/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotificationType;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public final class VariableListenerSupport<Solution_>
implements SupplyManager<Solution_> {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final List<VariableListenerNotifiable<Solution_>> notifiableList;
    private final Map<VariableDescriptor<Solution_>, List<VariableListenerNotifiable<Solution_>>> sourceVariableToNotifiableMap;
    private final Map<EntityDescriptor<Solution_>, List<VariableListenerNotifiable<Solution_>>> sourceEntityToNotifiableMap;
    private final Map<Demand<Solution_, ?>, Supply> supplyMap;
    private int nextGlobalOrder = 0;
    private boolean notificationQueuesAreEmpty;

    public VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector) {
        this.scoreDirector = scoreDirector;
        this.notifiableList = new ArrayList<VariableListenerNotifiable<Solution_>>();
        this.sourceVariableToNotifiableMap = new LinkedHashMap<VariableDescriptor<Solution_>, List<VariableListenerNotifiable<Solution_>>>();
        this.sourceEntityToNotifiableMap = new LinkedHashMap<EntityDescriptor<Solution_>, List<VariableListenerNotifiable<Solution_>>>();
        this.supplyMap = new LinkedHashMap();
    }

    public void linkVariableListeners() {
        this.notificationQueuesAreEmpty = true;
        for (EntityDescriptor<Solution_> entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (VariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                this.sourceVariableToNotifiableMap.put(variableDescriptor, new ArrayList());
            }
            this.sourceEntityToNotifiableMap.put(entityDescriptor, new ArrayList());
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.scoreDirector.getSolutionDescriptor().getEntityDescriptors()) {
            for (ShadowVariableDescriptor shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                int globalOrder;
                if (!shadowVariableDescriptor.hasVariableListener(this.scoreDirector)) continue;
                VariableListener<Solution_, ?> variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
                if (variableListener instanceof Supply) {
                    this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), (Supply)((Object)variableListener));
                }
                if (this.nextGlobalOrder <= (globalOrder = shadowVariableDescriptor.getGlobalShadowOrder())) {
                    this.nextGlobalOrder = globalOrder + 1;
                }
                VariableListenerNotifiable<Solution_> notifiable = new VariableListenerNotifiable<Solution_>(variableListener, globalOrder);
                for (VariableDescriptor source : shadowVariableDescriptor.getSourceVariableDescriptorList()) {
                    List<VariableListenerNotifiable<Solution_>> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                    variableNotifiableList.add(notifiable);
                    List<VariableListenerNotifiable<Solution_>> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                    if (entityNotifiableList.contains(notifiable)) continue;
                    entityNotifiableList.add(notifiable);
                }
                this.notifiableList.add(notifiable);
            }
        }
        Collections.sort(this.notifiableList);
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Solution_, Supply_> demand) {
        Supply supply = this.supplyMap.get(demand);
        if (supply == null) {
            supply = demand.createExternalizedSupply(this.scoreDirector);
            if (supply instanceof SourcedVariableListener) {
                SourcedVariableListener variableListener = (SourcedVariableListener)supply;
                if (this.scoreDirector.getWorkingSolution() != null) {
                    variableListener.resetWorkingSolution(this.scoreDirector);
                }
                VariableDescriptor source = variableListener.getSourceVariableDescriptor();
                VariableListenerNotifiable notifiable = new VariableListenerNotifiable(variableListener, this.nextGlobalOrder);
                ++this.nextGlobalOrder;
                List<VariableListenerNotifiable<Solution_>> variableNotifiableList = this.sourceVariableToNotifiableMap.get(source);
                variableNotifiableList.add(notifiable);
                List<VariableListenerNotifiable<Solution_>> entityNotifiableList = this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor());
                if (!entityNotifiableList.contains(notifiable)) {
                    entityNotifiableList.add(notifiable);
                }
                this.notifiableList.add(notifiable);
            }
            this.supplyMap.put(demand, supply);
        }
        return (Supply_)supply;
    }

    public void resetWorkingSolution() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableList) {
            VariableListener variableListener = notifiable.getVariableListener();
            variableListener.resetWorkingSolution(this.scoreDirector);
        }
    }

    public void clearWorkingSolution() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableList) {
            VariableListener variableListener = notifiable.getVariableListener();
            variableListener.close();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        List<VariableListenerNotifiable<Solution_>> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        if (!notifiableList.isEmpty()) {
            VariableListenerNotification notification = new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_ADDED);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiableList) {
                Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
                boolean added = notificationQueue.add(notification);
                if (!added) continue;
                notifiable.getVariableListener().beforeEntityAdded(this.scoreDirector, entity);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        List notifiableList = this.sourceVariableToNotifiableMap.getOrDefault(variableDescriptor, Collections.emptyList());
        if (!notifiableList.isEmpty()) {
            VariableListenerNotification notification = new VariableListenerNotification(entity, VariableListenerNotificationType.VARIABLE_CHANGED);
            for (VariableListenerNotifiable notifiable : notifiableList) {
                Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
                boolean added = notificationQueue.add(notification);
                if (!added) continue;
                notifiable.getVariableListener().beforeVariableChanged(this.scoreDirector, entity);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        List<VariableListenerNotifiable<Solution_>> notifiableList = this.sourceEntityToNotifiableMap.get(entityDescriptor);
        if (!notifiableList.isEmpty()) {
            VariableListenerNotification notification = new VariableListenerNotification(entity, VariableListenerNotificationType.ENTITY_REMOVED);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiableList) {
                Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
                boolean added = notificationQueue.add(notification);
                if (!added) continue;
                notifiable.getVariableListener().beforeEntityRemoved(this.scoreDirector, entity);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableList) {
            Collection<VariableListenerNotification> notificationQueue = notifiable.getNotificationQueue();
            int notifiedCount = 0;
            VariableListener<Solution_, Object> variableListener = notifiable.getVariableListener();
            for (VariableListenerNotification notification : notificationQueue) {
                Object entity = notification.getEntity();
                switch (notification.getType()) {
                    case ENTITY_ADDED: {
                        variableListener.afterEntityAdded(this.scoreDirector, entity);
                        break;
                    }
                    case VARIABLE_CHANGED: {
                        variableListener.afterVariableChanged(this.scoreDirector, entity);
                        break;
                    }
                    case ENTITY_REMOVED: {
                        variableListener.afterEntityRemoved(this.scoreDirector, entity);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The variableListenerNotificationType (" + notification.getType() + ") is not implemented.");
                    }
                }
                ++notifiedCount;
            }
            if (notifiedCount != notificationQueue.size()) {
                throw new IllegalStateException("The variableListener (" + variableListener.getClass() + ") has been notified with notifiedCount (" + notifiedCount + ") but after notification it has different size (" + notificationQueue.size() + ").\nMaybe that variableListener (" + variableListener.getClass() + ") changed an upstream shadow variable (which is illegal).");
            }
            notificationQueue.clear();
        }
        this.notificationQueuesAreEmpty = true;
    }

    public void triggerAllVariableListeners() {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(this.scoreDirector.getWorkingSolution(), this::triggerAllVariableListeners);
        this.triggerVariableListenersInNotificationQueues();
    }

    private void triggerAllVariableListeners(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        for (VariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            this.beforeVariableChanged(variableDescriptor, entity);
            this.afterVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

