/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class ConsumerSupport<Solution_, ProblemId_>
implements AutoCloseable {
    private final ProblemId_ problemId;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private final AtomicReference<Solution_> bestSolutionWaitingForConsumption = new AtomicReference();
    private final Semaphore activeConsumption = new Semaphore(1);
    private ExecutorService consumerExecutor = Executors.newSingleThreadExecutor();

    public ConsumerSupport(ProblemId_ problemId, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        this.problemId = problemId;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
    }

    void consumeIntermediateBestSolution(Solution_ bestSolution) {
        if (this.bestSolutionConsumer == null) {
            throw new IllegalStateException("No best solution consumer has been defined.");
        }
        this.bestSolutionWaitingForConsumption.set(bestSolution);
        this.tryConsumeWaitingIntermediateBestSolution();
    }

    void consumeFinalBestSolution(Solution_ finalBestSolution) {
        if (this.finalBestSolutionConsumer == null) {
            throw new IllegalStateException("No final best solution consumer has been defined.");
        }
        try {
            this.activeConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the final best solution consumption.");
        }
        this.scheduleIntermediateBestSolutionConsumption();
        this.consumerExecutor.submit(() -> {
            try {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(this.problemId, throwable);
            }
            finally {
                this.activeConsumption.release();
            }
        });
    }

    private void tryConsumeWaitingIntermediateBestSolution() {
        if (this.bestSolutionWaitingForConsumption.get() == null) {
            return;
        }
        if (this.activeConsumption.tryAcquire()) {
            this.scheduleIntermediateBestSolutionConsumption().thenRunAsync(this::tryConsumeWaitingIntermediateBestSolution, this.consumerExecutor);
        }
    }

    private CompletableFuture<Void> scheduleIntermediateBestSolutionConsumption() {
        return CompletableFuture.runAsync(() -> {
            Object bestSolution = this.bestSolutionWaitingForConsumption.getAndSet(null);
            try {
                if (bestSolution != null) {
                    this.bestSolutionConsumer.accept(bestSolution);
                }
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(this.problemId, throwable);
            }
            finally {
                this.activeConsumption.release();
            }
        }, this.consumerExecutor);
    }

    @Override
    public void close() {
        if (this.consumerExecutor != null) {
            this.consumerExecutor.shutdownNow();
            this.consumerExecutor = null;
        }
    }
}

