/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;

public class DefaultEdgeFilter
implements EdgeFilter {
    private static int DEFAULT_FILTER_ID = 0;
    private final boolean bwd;
    private final boolean fwd;
    private final BooleanEncodedValue accessEnc;
    private int filterId;

    private DefaultEdgeFilter(BooleanEncodedValue accessEnc, boolean fwd, boolean bwd, int filterId) {
        this.accessEnc = accessEnc;
        this.fwd = fwd;
        this.bwd = bwd;
        this.filterId = filterId;
    }

    public static DefaultEdgeFilter outEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, true, false, DEFAULT_FILTER_ID);
    }

    public static DefaultEdgeFilter inEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, false, true, DEFAULT_FILTER_ID);
    }

    public static DefaultEdgeFilter allEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, true, true, DEFAULT_FILTER_ID);
    }

    public static DefaultEdgeFilter outEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.outEdges(flagEncoder.getAccessEnc());
    }

    public static DefaultEdgeFilter inEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.inEdges(flagEncoder.getAccessEnc());
    }

    public static DefaultEdgeFilter allEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.allEdges(flagEncoder.getAccessEnc());
    }

    public DefaultEdgeFilter setFilterId(int filterId) {
        this.filterId = filterId;
        return this;
    }

    public BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (iter.getBaseNode() == iter.getAdjNode()) {
            return iter.get(this.accessEnc) || iter.getReverse(this.accessEnc);
        }
        return this.fwd && iter.get(this.accessEnc) || this.bwd && iter.getReverse(this.accessEnc);
    }

    public String toString() {
        return this.accessEnc.toString() + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEdgeFilter that = (DefaultEdgeFilter)o;
        if (this.bwd != that.bwd) {
            return false;
        }
        if (this.fwd != that.fwd) {
            return false;
        }
        if (this.filterId != that.filterId) {
            return false;
        }
        return this.accessEnc.equals(that.accessEnc);
    }

    public int hashCode() {
        int result = this.bwd ? 1 : 0;
        result = 31 * result + (this.fwd ? 1 : 0);
        result = 31 * result + this.accessEnc.hashCode();
        result = 31 * result + this.filterId;
        return result;
    }
}

