/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.Country;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.shapes.GHPoint;
import java.util.List;

public class SpatialRuleParser
implements TagParser {
    private final IntEncodedValue spatialRuleEnc;
    private SpatialRuleLookup spatialRuleLookup;

    public SpatialRuleParser(SpatialRuleLookup spatialRuleLookup) {
        this(spatialRuleLookup, new EnumEncodedValue<Country>("country", Country.class));
    }

    public SpatialRuleParser(SpatialRuleLookup spatialRuleLookup, IntEncodedValue spatialRuleEnc) {
        this.spatialRuleLookup = spatialRuleLookup;
        this.spatialRuleEnc = spatialRuleEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        if (this.spatialRuleEnc == null) {
            throw new IllegalStateException("SpatialRuleLookup was not initialized before building the EncodingManager");
        }
        registerNewEncodedValue.add(this.spatialRuleEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        GHPoint estimatedCenter = way.getTag("estimated_center", null);
        if (estimatedCenter != null) {
            SpatialRule rule = this.spatialRuleLookup.lookupRule(estimatedCenter);
            way.setTag("spatial_rule", rule);
            this.spatialRuleEnc.setInt(false, edgeFlags, this.spatialRuleLookup.getSpatialId(rule));
        }
        return edgeFlags;
    }
}

