/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules.countries;

import com.graphhopper.routing.profiles.Country;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.util.spatialrules.DefaultSpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;

public class GermanySpatialRule
extends DefaultSpatialRule {
    @Override
    public double getMaxSpeed(String highwayTag, double _default) {
        switch (highwayTag) {
            case "motorway": 
            case "trunk": {
                return 2.147483647E9;
            }
            case "residential": {
                return 100.0;
            }
            case "living_street": {
                return 4.0;
            }
        }
        return super.getMaxSpeed(highwayTag, _default);
    }

    @Override
    public RoadAccess getAccess(String highwayTag, TransportationMode transportationMode, RoadAccess _default) {
        if (transportationMode == TransportationMode.MOTOR_VEHICLE && highwayTag.equals("track")) {
            return RoadAccess.DESTINATION;
        }
        return super.getAccess(highwayTag, transportationMode, _default);
    }

    @Override
    public String getId() {
        return Country.DEU.toString();
    }
}

