/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.MMapDataAccess;
import com.graphhopper.storage.RAMDataAccess;
import com.graphhopper.storage.RAMIntDataAccess;
import com.graphhopper.storage.UnsafeDataAccess;
import com.graphhopper.util.Helper;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GHDirectory
implements Directory {
    protected final String location;
    private final DAType defaultType;
    private final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected Map<String, DataAccess> map = new HashMap<String, DataAccess>();
    protected Map<String, DAType> types = new HashMap<String, DAType>();

    public GHDirectory(String _location, DAType defaultType) {
        this.defaultType = defaultType;
        if (Helper.isEmpty((String)_location)) {
            _location = new File("").getAbsolutePath();
        }
        if (!_location.endsWith("/")) {
            _location = _location + "/";
        }
        this.location = _location;
        File dir = new File(this.location);
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeException("file '" + dir + "' exists but is not a directory");
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public Directory put(String name, DAType type) {
        if (!name.equals(Helper.toLowerCase((String)name))) {
            throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
        }
        this.types.put(name, type);
        return this;
    }

    @Override
    public DataAccess find(String name) {
        DAType type = this.types.get(name);
        if (type == null) {
            type = this.defaultType;
        }
        return this.find(name, type);
    }

    @Override
    public DataAccess find(String name, DAType type) {
        if (!name.equals(Helper.toLowerCase((String)name))) {
            throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
        }
        DataAccess da = this.map.get(name);
        if (da != null) {
            if (!type.equals(da.getType())) {
                throw new IllegalStateException("Found existing DataAccess object '" + name + "' but types did not match. Requested:" + type + ", was:" + da.getType());
            }
            return da;
        }
        da = type.isInMemory() ? (type.isInteg() ? (type.isStoring() ? new RAMIntDataAccess(name, this.location, true, this.byteOrder) : new RAMIntDataAccess(name, this.location, false, this.byteOrder)) : (type.isStoring() ? new RAMDataAccess(name, this.location, true, this.byteOrder) : new RAMDataAccess(name, this.location, false, this.byteOrder))) : (type.isMMap() ? new MMapDataAccess(name, this.location, this.byteOrder, type.isAllowWrites()) : new UnsafeDataAccess(name, this.location, this.byteOrder));
        this.map.put(name, da);
        return da;
    }

    @Override
    public void clear() {
        MMapDataAccess mmapDA = null;
        for (DataAccess da : this.map.values()) {
            if (da instanceof MMapDataAccess) {
                mmapDA = (MMapDataAccess)da;
            }
            this.removeDA(da, da.getName(), false);
        }
        if (mmapDA != null) {
            Helper.cleanHack();
        }
        this.map.clear();
    }

    @Override
    public void remove(DataAccess da) {
        this.removeFromMap(da.getName());
        this.removeDA(da, da.getName(), true);
    }

    void removeDA(DataAccess da, String name, boolean forceClean) {
        if (da instanceof MMapDataAccess) {
            ((MMapDataAccess)da).close(forceClean);
        } else {
            da.close();
        }
        if (da.getType().isStoring()) {
            Helper.removeDir((File)new File(this.location + name));
        }
    }

    void removeFromMap(String name) {
        DataAccess da = this.map.remove(name);
        if (da == null) {
            throw new IllegalStateException("Couldn't remove dataAccess object:" + name);
        }
    }

    @Override
    public DAType getDefaultType() {
        return this.defaultType;
    }

    public boolean isStoring() {
        return this.defaultType.isStoring();
    }

    @Override
    public Directory create() {
        if (this.isStoring()) {
            new File(this.location).mkdirs();
        }
        return this;
    }

    @Override
    public Collection<DataAccess> getAll() {
        return this.map.values();
    }

    public String toString() {
        return this.getLocation();
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

