/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms.beliefsystem.simple;

import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.agenda.TruthMaintenanceSystemActivation;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.simple.SimpleBeliefSet;
import org.drools.tms.beliefsystem.simple.SimpleLogicalDependency;
import org.kie.api.runtime.rule.FactHandle;

public class SimpleBeliefSystem
implements BeliefSystem<SimpleMode> {
    private InternalWorkingMemoryEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public SimpleBeliefSystem(InternalWorkingMemoryEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public SimpleMode asMode(Object value) {
        return new SimpleMode();
    }

    @Override
    public BeliefSet<SimpleMode> insert(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getMode());
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (empty && bfh.getEqualityKey().getStatus() == 2) {
            this.ep.insert(bfh, bfh.getObject(), node.getJustifier().getRule(), (TerminalNode)node.getJustifier().getTuple().getTupleSink(), typeConf);
        }
        return beliefSet;
    }

    @Override
    public BeliefSet<SimpleMode> insert(SimpleMode mode, RuleImpl rule, TruthMaintenanceSystemActivation activation, Object payload, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(mode);
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (empty && bfh.getEqualityKey().getStatus() == 2) {
            this.ep.insert(bfh, bfh.getObject(), rule, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null, typeConf);
        }
        return beliefSet;
    }

    @Override
    public void read(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getMode());
    }

    @Override
    public void delete(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context) {
        this.delete(node.getMode(), node.getJustifier().getRule(), (Activation)node.getJustifier(), node.getObject(), beliefSet, context);
    }

    @Override
    public void delete(SimpleMode mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<SimpleMode> beliefSet, PropagationContext context) {
        beliefSet.remove(mode);
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && bfh.getEqualityKey() != null && bfh.getEqualityKey().getStatus() == 2) {
            this.ep.delete(bfh, bfh.getObject(), this.getObjectTypeConf(beliefSet), context.getRuleOrigin(), null, activation != null ? (TerminalNode)activation.getTuple().getTupleSink() : null);
        } else if (!beliefSet.isEmpty() && bfh.getObject() == payload && payload != bfh.getObject()) {
            WorkingMemoryEntryPoint ep = bfh.getEntryPoint(this.ep.getReteEvaluator());
            ep.getObjectStore().updateHandle(bfh, ((LogicalDependency)beliefSet.getFirst().getObject()).getObject());
            ep.update((FactHandle)bfh, bfh.getObject(), PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
        }
        if (beliefSet.isEmpty() && bfh.getEqualityKey() != null) {
            EqualityKey key = bfh.getEqualityKey();
            key.setLogicalFactHandle(null);
            ((TruthMaintenanceSystemEqualityKey)key).setBeliefSet(null);
            if (key.getStatus() == 2) {
                this.tms.remove(key);
            }
        }
    }

    @Override
    public void stage(PropagationContext context, BeliefSet<SimpleMode> beliefSet) {
        InternalFactHandle bfh = beliefSet.getFactHandle();
        this.ep.delete(bfh, bfh.getObject(), this.getObjectTypeConf(beliefSet), context.getRuleOrigin(), null);
        bfh.getEqualityKey().setStatus(1);
    }

    @Override
    public void unstage(PropagationContext context, BeliefSet<SimpleMode> beliefSet) {
        InternalFactHandle bfh = beliefSet.getFactHandle();
        bfh.getEqualityKey().setStatus(2);
        this.ep.insert(bfh, bfh.getObject(), context.getRuleOrigin(), null, this.getObjectTypeConf(beliefSet));
    }

    private ObjectTypeConf getObjectTypeConf(BeliefSet beliefSet) {
        InternalFactHandle fh = beliefSet.getFactHandle();
        ObjectTypeConfigurationRegistry reg = this.ep.getObjectTypeConfigurationRegistry();
        ObjectTypeConf typeConf = reg.getOrCreateObjectTypeConf(this.ep.getEntryPoint(), fh.getObject());
        return typeConf;
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(TruthMaintenanceSystemActivation activation, BeliefSet beliefSet, Object object, Object value) {
        SimpleMode mode = new SimpleMode();
        SimpleLogicalDependency<SimpleMode> dep = new SimpleLogicalDependency<SimpleMode>(activation, beliefSet, object, mode);
        mode.setObject(dep);
        return dep;
    }

    public InternalWorkingMemoryEntryPoint getEp() {
        return this.ep;
    }

    public void setEp(NamedEntryPoint ep) {
        this.ep = ep;
    }

    public TruthMaintenanceSystem getTms() {
        return this.tms;
    }

    public void setTms(TruthMaintenanceSystem tms) {
        this.tms = tms;
    }
}

