/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetFilterBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBridgeBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBridgeBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetScoringBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.constraint.streams.bavet.common.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndexFactory;
import org.optaplanner.constraint.streams.bavet.tri.BavetJoinTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bi.InnerBiConstraintStream;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public abstract class BavetAbstractBiConstraintStream<Solution_, A, B>
extends BavetAbstractConstraintStream<Solution_>
implements InnerBiConstraintStream<A, B> {
    protected final List<BavetAbstractBiConstraintStream<Solution_, A, B>> childStreamList = new ArrayList<BavetAbstractBiConstraintStream<Solution_, A, B>>(2);

    public BavetAbstractBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
    }

    protected void addChildStream(BavetAbstractBiConstraintStream<Solution_, A, B> childStream) {
        this.childStreamList.add(childStream);
    }

    public BavetAbstractBiConstraintStream<Solution_, A, B> filter(BiPredicate<A, B> predicate) {
        BavetFilterBiConstraintStream stream = new BavetFilterBiConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        if (!(otherStream instanceof BavetAbstractUniConstraintStream)) {
            throw new IllegalStateException("The streams (" + this + ", " + otherStream + ") are not build from the same " + ConstraintFactory.class.getSimpleName() + ".");
        }
        BavetAbstractUniConstraintStream other = (BavetAbstractUniConstraintStream)otherStream;
        if (this.constraintFactory != other.getConstraintFactory()) {
            throw new IllegalStateException("The streams (" + this + ", " + other + ") are build from different constraintFactories (" + this.constraintFactory + ", " + (BavetConstraintFactory)other.getConstraintFactory() + ").");
        }
        if (!(joiner instanceof DefaultTriJoiner)) {
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        DefaultTriJoiner castedJoiner = (DefaultTriJoiner)joiner;
        BavetIndexFactory indexFactory = new BavetIndexFactory(castedJoiner);
        BavetJoinBridgeBiConstraintStream leftBridge = new BavetJoinBridgeBiConstraintStream(this.constraintFactory, this, true, JoinerUtils.combineLeftMappings(castedJoiner), indexFactory);
        this.addChildStream(leftBridge);
        BavetJoinBridgeUniConstraintStream rightBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, other, false, JoinerUtils.combineRightMappings(castedJoiner), indexFactory);
        other.addChildStream(rightBridge);
        BavetJoinTriConstraintStream joinStream = new BavetJoinTriConstraintStream(this.constraintFactory, leftBridge, rightBridge);
        leftBridge.setJoinStream(joinStream);
        rightBridge.setJoinStream(joinStream);
        return joinStream;
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.constraintFactory.forEach(otherClass), joiners);
        }
        return this.join(this.constraintFactory.from(otherClass), joiners);
    }

    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> collectorA, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> collectorB) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> collectorA, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> collectorB, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> collectorA, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> collectorB, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> collectorB, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> collectorB, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        BavetGroupBridgeBiConstraintStream bridge = new BavetGroupBridgeBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.childStreamList.add(bridge);
        BavetGroupBiConstraintStream groupStream = new BavetGroupBiConstraintStream(this.constraintFactory, bridge, collector.finisher());
        bridge.setGroupStream(groupStream);
        return groupStream;
    }

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiFunction<A, B, GroupKeyC_> groupKeyCMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiFunction<A, B, GroupKeyC_> groupKeyCMapping, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiFunction<A, B, GroupKeyC_> groupKeyCMapping, BiFunction<A, B, GroupKeyD_> groupKeyDMapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultA_> UniConstraintStream<ResultA_> map(BiFunction<A, B, ResultA_> mapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultB_> BiConstraintStream<A, ResultB_> flattenLast(Function<B, Iterable<ResultB_>> mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringBiConstraintStream stream = new BavetScoringBiConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    public BavetAbstractBiNode<A, B> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> parentNode) {
        BavetAbstractBiNode<A, B> node = this.createNode(buildPolicy, constraintWeight, parentNode);
        node = this.processNode(buildPolicy, parentNode, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, node);
        return node;
    }

    protected BavetAbstractBiNode<A, B> processNode(BavetNodeBuildPolicy<Solution_> buildPolicy, BavetAbstractBiNode<A, B> parentNode, BavetAbstractBiNode<A, B> node) {
        BavetAbstractBiNode<A, B> sharedNode = buildPolicy.retrieveSharedNode(node);
        if (sharedNode != node) {
            return sharedNode;
        }
        if (parentNode != null) {
            parentNode.addChildNode(node);
        }
        return node;
    }

    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> node) {
        if (this.childStreamList.isEmpty()) {
            throw new IllegalStateException("The stream (" + this + ") leads to nowhere.\nMaybe don't create it.");
        }
        for (BavetAbstractBiConstraintStream<Solution_, A, B> childStream : this.childStreamList) {
            childStream.createNodeChain(buildPolicy, constraintWeight, node);
        }
    }

    protected abstract BavetAbstractBiNode<A, B> createNode(BavetNodeBuildPolicy<Solution_> var1, Score<?> var2, BavetAbstractBiNode<A, B> var3);
}

