/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityAddedNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityRemovedNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableChangedNotification;

abstract class VariableListenerNotification {
    protected final Object entity;

    static VariableListenerNotification entityAdded(Object entity) {
        return new EntityAddedNotification(entity);
    }

    static VariableListenerNotification variableChanged(Object entity) {
        return new VariableChangedNotification(entity);
    }

    static VariableListenerNotification entityRemoved(Object entity) {
        return new EntityRemovedNotification(entity);
    }

    protected VariableListenerNotification(Object entity) {
        this.entity = entity;
    }

    abstract <Solution_> void triggerBefore(VariableListener<Solution_, Object> var1, ScoreDirector<Solution_> var2);

    abstract <Solution_> void triggerAfter(VariableListener<Solution_, Object> var1, ScoreDirector<Solution_> var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableListenerNotification that = (VariableListenerNotification)o;
        return this.entity.equals(that.entity);
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode(this.entity), this.getClass());
    }
}

