/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.NotifiableRegistry;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public final class VariableListenerSupport<Solution_>
implements SupplyManager<Solution_> {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final NotifiableRegistry<Solution_> notifiableRegistry;
    private final Map<Demand<Solution_, ?>, Supply> supplyMap;
    private boolean notificationQueuesAreEmpty;
    private int nextGlobalOrder = 0;

    VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector, NotifiableRegistry<Solution_> notifiableRegistry, Map<Demand<Solution_, ?>, Supply> supplyMap) {
        this.scoreDirector = scoreDirector;
        this.notifiableRegistry = notifiableRegistry;
        this.supplyMap = supplyMap;
    }

    public static <Solution_> VariableListenerSupport<Solution_> create(InnerScoreDirector<Solution_, ?> scoreDirector) {
        return new VariableListenerSupport<Solution_>(scoreDirector, new NotifiableRegistry<Solution_>(scoreDirector.getSolutionDescriptor()), new LinkedHashMap());
    }

    public void linkVariableListeners() {
        this.notificationQueuesAreEmpty = true;
        this.scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().flatMap(entityDescriptor -> entityDescriptor.getDeclaredShadowVariableDescriptors().stream()).filter(descriptor -> descriptor.hasVariableListener(this.scoreDirector)).sorted(Comparator.comparingInt(ShadowVariableDescriptor::getGlobalShadowOrder)).forEach(this::processShadowVariableDescriptor);
    }

    private void processShadowVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        VariableListener<Solution_, ?> variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
        if (variableListener instanceof Supply) {
            this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), (Supply)((Object)variableListener));
        }
        int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
        this.notifiableRegistry.registerNotifiable(shadowVariableDescriptor.getSourceVariableDescriptorList(), new VariableListenerNotifiable<Solution_>(this.scoreDirector, variableListener, globalOrder));
        this.nextGlobalOrder = globalOrder + 1;
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Solution_, Supply_> demand) {
        return (Supply_)this.supplyMap.computeIfAbsent(demand, this::createSupply);
    }

    private Supply createSupply(Demand<Solution_, ?> demand) {
        Object supply = demand.createExternalizedSupply(this.scoreDirector);
        if (supply instanceof SourcedVariableListener) {
            SourcedVariableListener variableListener = (SourcedVariableListener)supply;
            if (this.scoreDirector.getWorkingSolution() != null) {
                variableListener.resetWorkingSolution(this.scoreDirector);
            }
            this.notifiableRegistry.registerNotifiable(variableListener.getSourceVariableDescriptor(), new VariableListenerNotifiable(this.scoreDirector, variableListener, this.nextGlobalOrder++));
        }
        return supply;
    }

    public void resetWorkingSolution() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableRegistry.getAll()) {
            notifiable.resetWorkingSolution();
        }
    }

    public void close() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableRegistry.getAll()) {
            notifiable.closeVariableListener();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            VariableListenerNotification notification = VariableListenerNotification.entityAdded(entity);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            VariableListenerNotification notification = VariableListenerNotification.variableChanged(entity);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            VariableListenerNotification notification = VariableListenerNotification.entityRemoved(entity);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (VariableListenerNotifiable<Solution_> notifiable : this.notifiableRegistry.getAll()) {
            notifiable.triggerAllNotifications();
        }
        this.notificationQueuesAreEmpty = true;
    }

    public void forceTriggerAllVariableListeners() {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(this.scoreDirector.getWorkingSolution(), this::simulateGenuineVariableChange);
        this.triggerVariableListenersInNotificationQueues();
    }

    private void simulateGenuineVariableChange(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        for (VariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            this.beforeVariableChanged(variableDescriptor, entity);
            this.afterVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

