/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.IterableSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class ChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final EntitySelector<Solution_> entitySelector;
    protected final ValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public ChangeMoveSelector(EntitySelector<Solution_> entitySelector, ValueSelector<Solution_> valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor.isChained();
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return !this.chained;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        if (this.chained) {
            SupplyManager<Solution_> supplyManager = solverScope.getScoreDirector().getSupplyManager();
            this.inverseVariableSupply = (SingletonInverseVariableSupply)supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(this.valueSelector.getVariableDescriptor()));
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        if (this.chained) {
            this.inverseVariableSupply = null;
        }
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        final GenuineVariableDescriptor<Solution_> variableDescriptor = this.valueSelector.getVariableDescriptor();
        if (!this.randomSelection) {
            if (this.chained) {
                return new AbstractOriginalChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                    @Override
                    protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                        return new ChainedChangeMove(variableDescriptor, entity, toValue, ChangeMoveSelector.this.inverseVariableSupply);
                    }
                };
            }
            return new AbstractOriginalChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                @Override
                protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                    return new ChangeMove(variableDescriptor, entity, toValue);
                }
            };
        }
        if (this.chained) {
            return new AbstractRandomChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                @Override
                protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                    return new ChainedChangeMove(variableDescriptor, entity, toValue, ChangeMoveSelector.this.inverseVariableSupply);
                }
            };
        }
        return new AbstractRandomChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

            @Override
            protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                return new ChangeMove(variableDescriptor, entity, toValue);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

